/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;

public class LocalCollectionOutputFormat<T>
implements OutputFormat<T>,
InputTypeConfigurable {
    private static final long serialVersionUID = 1L;
    private static Map<Integer, Collection<?>> RESULT_HOLDER = new HashMap();
    private transient ArrayList<T> taskResult;
    private TypeSerializer<T> typeSerializer;
    private int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalCollectionOutputFormat(Collection<T> out) {
        Map<Integer, Collection<?>> map = RESULT_HOLDER;
        synchronized (map) {
            this.id = this.generateRandomId();
            RESULT_HOLDER.put(this.id, out);
        }
    }

    private int generateRandomId() {
        int num = (int)(Math.random() * 2.147483647E9);
        while (RESULT_HOLDER.containsKey(num)) {
            num = (int)(Math.random() * 2.147483647E9);
        }
        return num;
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.taskResult = new ArrayList();
    }

    public void writeRecord(T record) throws IOException {
        Object recordCopy = this.typeSerializer.createInstance();
        recordCopy = this.typeSerializer.copy(record, recordCopy);
        this.taskResult.add(recordCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Map<Integer, Collection<?>> map = RESULT_HOLDER;
        synchronized (map) {
            Collection<?> result = RESULT_HOLDER.get(this.id);
            result.addAll(this.taskResult);
        }
    }

    @Override
    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        this.typeSerializer = type.createSerializer(executionConfig);
    }
}

