/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.operators.translation.PlanProjectOperator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class ProjectOperator<IN, OUT extends Tuple>
extends SingleInputOperator<IN, OUT, ProjectOperator<IN, OUT>> {
    protected final int[] fields;
    private Projection<IN> proj;

    public ProjectOperator(DataSet<IN> input, int[] fields, TupleTypeInfo<OUT> returnType) {
        super(input, returnType);
        this.fields = fields;
        this.proj = null;
    }

    public ProjectOperator(DataSet<IN> input, int[] fields, TupleTypeInfo<OUT> returnType, Projection<IN> proj) {
        super(input, returnType);
        this.fields = fields;
        this.proj = proj;
    }

    @Override
    protected MapOperatorBase<IN, OUT, MapFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : "Projection " + Arrays.toString(this.fields);
        PlanProjectOperator ppo = new PlanProjectOperator(this.fields, name, this.getInputType(), this.getResultType());
        ppo.setInput(input);
        ppo.setDegreeOfParallelism(this.getParallelism());
        ppo.setSemanticProperties(SemanticPropUtil.createProjectionPropertiesSingle(this.fields));
        return ppo;
    }

    @Override
    public <OUT extends Tuple> ProjectOperator<?, OUT> project(int ... fieldIndexes) {
        ((Projection)this.proj).acceptAdditionalIndexes(fieldIndexes);
        return this.proj.projectTupleX();
    }

    @Deprecated
    public <OUT extends Tuple> ProjectOperator<IN, OUT> types(Class<?> ... types) {
        TupleTypeInfo typeInfo = (TupleTypeInfo)this.getResultType();
        if (types.length != typeInfo.getArity()) {
            throw new InvalidProgramException("Provided types do not match projection.");
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> typeClass = types[i];
            if (typeClass.equals(typeInfo.getTypeAt(i).getTypeClass())) continue;
            throw new InvalidProgramException("Provided type " + typeClass.getSimpleName() + " at position " + i + " does not match projection");
        }
        return this;
    }

    public static class Projection<T> {
        private final DataSet<T> ds;
        private int[] fieldIndexes;

        public Projection(DataSet<T> ds, int[] fieldIndexes) {
            if (!(ds.getType() instanceof TupleTypeInfo)) {
                throw new UnsupportedOperationException("project() can only be applied to DataSets of Tuples.");
            }
            if (fieldIndexes.length == 0) {
                throw new IllegalArgumentException("project() needs to select at least one (1) field.");
            }
            if (fieldIndexes.length > 24) {
                throw new IllegalArgumentException("project() may select only up to (24) fields.");
            }
            int maxFieldIndex = ((TupleTypeInfo)ds.getType()).getArity();
            for (int i = 0; i < fieldIndexes.length; ++i) {
                Preconditions.checkElementIndex((int)fieldIndexes[i], (int)maxFieldIndex);
            }
            this.ds = ds;
            this.fieldIndexes = fieldIndexes;
        }

        private void acceptAdditionalIndexes(int ... additionalIndexes) {
            if (additionalIndexes.length == 0) {
                throw new IllegalArgumentException("project() needs to select at least one (1) field.");
            }
            if (additionalIndexes.length > 24) {
                throw new IllegalArgumentException("project() may select only up to (24) fields.");
            }
            int offset = this.fieldIndexes.length;
            this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + additionalIndexes.length);
            int maxFieldIndex = ((TupleTypeInfo)this.ds.getType()).getArity();
            for (int i = 0; i < additionalIndexes.length; ++i) {
                Preconditions.checkElementIndex((int)additionalIndexes[i], (int)maxFieldIndex);
                this.fieldIndexes[offset + i] = additionalIndexes[i];
            }
        }

        public <OUT extends Tuple> ProjectOperator<T, OUT> projectTupleX() {
            ProjectOperator<T, Tuple> projOperator = null;
            switch (this.fieldIndexes.length) {
                case 1: {
                    projOperator = this.projectTuple1();
                    break;
                }
                case 2: {
                    projOperator = this.projectTuple2();
                    break;
                }
                case 3: {
                    projOperator = this.projectTuple3();
                    break;
                }
                case 4: {
                    projOperator = this.projectTuple4();
                    break;
                }
                case 5: {
                    projOperator = this.projectTuple5();
                    break;
                }
                case 6: {
                    projOperator = this.projectTuple6();
                    break;
                }
                case 7: {
                    projOperator = this.projectTuple7();
                    break;
                }
                case 8: {
                    projOperator = this.projectTuple8();
                    break;
                }
                case 9: {
                    projOperator = this.projectTuple9();
                    break;
                }
                case 10: {
                    projOperator = this.projectTuple10();
                    break;
                }
                case 11: {
                    projOperator = this.projectTuple11();
                    break;
                }
                case 12: {
                    projOperator = this.projectTuple12();
                    break;
                }
                case 13: {
                    projOperator = this.projectTuple13();
                    break;
                }
                case 14: {
                    projOperator = this.projectTuple14();
                    break;
                }
                case 15: {
                    projOperator = this.projectTuple15();
                    break;
                }
                case 16: {
                    projOperator = this.projectTuple16();
                    break;
                }
                case 17: {
                    projOperator = this.projectTuple17();
                    break;
                }
                case 18: {
                    projOperator = this.projectTuple18();
                    break;
                }
                case 19: {
                    projOperator = this.projectTuple19();
                    break;
                }
                case 20: {
                    projOperator = this.projectTuple20();
                    break;
                }
                case 21: {
                    projOperator = this.projectTuple21();
                    break;
                }
                case 22: {
                    projOperator = this.projectTuple22();
                    break;
                }
                case 23: {
                    projOperator = this.projectTuple23();
                    break;
                }
                case 24: {
                    projOperator = this.projectTuple24();
                    break;
                }
                case 25: {
                    projOperator = this.projectTuple25();
                    break;
                }
                default: {
                    throw new IllegalStateException("Excessive arity in tuple.");
                }
            }
            return projOperator;
        }

        public <T0> ProjectOperator<T, Tuple1<T0>> projectTuple1() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1> ProjectOperator<T, Tuple2<T0, T1>> projectTuple2() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2> ProjectOperator<T, Tuple3<T0, T1, T2>> projectTuple3() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3> ProjectOperator<T, Tuple4<T0, T1, T2, T3>> projectTuple4() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4> ProjectOperator<T, Tuple5<T0, T1, T2, T3, T4>> projectTuple5() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5> ProjectOperator<T, Tuple6<T0, T1, T2, T3, T4, T5>> projectTuple6() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6> ProjectOperator<T, Tuple7<T0, T1, T2, T3, T4, T5, T6>> projectTuple7() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7> ProjectOperator<T, Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> projectTuple8() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8> ProjectOperator<T, Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> projectTuple9() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> ProjectOperator<T, Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> projectTuple10() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ProjectOperator<T, Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> projectTuple11() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ProjectOperator<T, Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> projectTuple12() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ProjectOperator<T, Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> projectTuple13() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ProjectOperator<T, Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> projectTuple14() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ProjectOperator<T, Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> projectTuple15() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ProjectOperator<T, Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> projectTuple16() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ProjectOperator<T, Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> projectTuple17() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ProjectOperator<T, Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> projectTuple18() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ProjectOperator<T, Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> projectTuple19() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ProjectOperator<T, Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> projectTuple20() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ProjectOperator<T, Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> projectTuple21() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ProjectOperator<T, Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> projectTuple22() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ProjectOperator<T, Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> projectTuple23() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> ProjectOperator<T, Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> projectTuple24() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> ProjectOperator<T, Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> projectTuple25() {
            TypeInformation<T>[] fTypes = this.extractFieldTypes(this.fieldIndexes, this.ds.getType());
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectOperator(this.ds, this.fieldIndexes, tType, this);
        }

        private TypeInformation<?>[] extractFieldTypes(int[] fields, TypeInformation<?> inType) {
            TupleTypeInfo inTupleType = (TupleTypeInfo)inType;
            TypeInformation[] fieldTypes = new TypeInformation[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                fieldTypes[i] = inTupleType.getTypeAt(fields[i]);
            }
            return fieldTypes;
        }
    }
}

