/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.typeutils.CompositeTypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeStatefulSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeStatelessSerializerFactory;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.KeyFieldOutOfBoundsException;
import org.apache.flink.types.NullKeyFieldException;

public abstract class TupleComparatorBase<T>
extends CompositeTypeComparator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] keyPositions;
    protected TypeComparator[] comparators;
    protected TypeSerializerFactory<Object>[] serializerFactories;
    protected int[] normalizedKeyLengths;
    protected int numLeadingNormalizableKeys;
    protected int normalizableKeyPrefixLen;
    protected boolean invertNormKey;
    protected transient TypeSerializer[] serializers;
    protected transient Object[] deserializedFields1;
    protected transient Object[] deserializedFields2;
    public static final int[] HASH_SALT = new int[]{73, 79, 97, 113, 131, 197, 199, 311, 337, 373, 719, 733, 919, 971, 991, 1193, 1931, 3119, 3779, 7793, 7937, 9311, 9377, 11939, 19391, 19937, 37199, 39119, 71993, 91193, 93719, 93911};

    public TupleComparatorBase(int[] keyPositions, TypeComparator<?>[] comparators, TypeSerializer<?>[] serializers) {
        TypeComparator k;
        this.keyPositions = keyPositions;
        this.comparators = comparators;
        this.serializers = serializers;
        this.serializerFactories = new TypeSerializerFactory[this.serializers.length];
        for (int i = 0; i < serializers.length; ++i) {
            this.serializerFactories[i] = (TypeSerializerFactory)(this.serializers[i].isStateful() ? new RuntimeStatefulSerializerFactory<Object>(this.serializers[i], Object.class) : new RuntimeStatelessSerializerFactory<Object>(this.serializers[i], Object.class));
        }
        this.normalizedKeyLengths = new int[keyPositions.length];
        int nKeys = 0;
        int nKeyLen = 0;
        boolean inverted = false;
        for (int i = 0; i < this.keyPositions.length && (k = this.comparators[i]).supportsNormalizedKey(); ++i) {
            if (i == 0) {
                inverted = k.invertNormalizedKey();
            } else if (k.invertNormalizedKey() != inverted) break;
            ++nKeys;
            int len = k.getNormalizeKeyLen();
            if (len < 0) {
                throw new RuntimeException("Comparator " + k.getClass().getName() + " specifies an invalid length for the normalized key: " + len);
            }
            this.normalizedKeyLengths[i] = len;
            if ((nKeyLen += len) >= 0) continue;
            nKeyLen = Integer.MAX_VALUE;
            break;
        }
        this.numLeadingNormalizableKeys = nKeys;
        this.normalizableKeyPrefixLen = nKeyLen;
        this.invertNormKey = inverted;
    }

    protected TupleComparatorBase(TupleComparatorBase<T> toClone) {
        this.privateDuplicate(toClone);
    }

    protected void privateDuplicate(TupleComparatorBase<T> toClone) {
        this.keyPositions = toClone.keyPositions;
        this.serializerFactories = toClone.serializerFactories;
        this.comparators = new TypeComparator[toClone.comparators.length];
        for (int i = 0; i < toClone.comparators.length; ++i) {
            this.comparators[i] = toClone.comparators[i].duplicate();
        }
        this.normalizedKeyLengths = toClone.normalizedKeyLengths;
        this.numLeadingNormalizableKeys = toClone.numLeadingNormalizableKeys;
        this.normalizableKeyPrefixLen = toClone.normalizableKeyPrefixLen;
        this.invertNormKey = toClone.invertNormKey;
    }

    protected int[] getKeyPositions() {
        return this.keyPositions;
    }

    public void getFlatComparator(List<TypeComparator> flatComparators) {
        for (int i = 0; i < this.comparators.length; ++i) {
            if (this.comparators[i] instanceof CompositeTypeComparator) {
                ((CompositeTypeComparator)this.comparators[i]).getFlatComparator(flatComparators);
                continue;
            }
            flatComparators.add(this.comparators[i]);
        }
    }

    public int compareToReference(TypeComparator<T> referencedComparator) {
        int i;
        TupleComparatorBase other = (TupleComparatorBase)referencedComparator;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                int cmp = this.comparators[i].compareToReference(other.comparators[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int i;
        if (this.deserializedFields1 == null) {
            this.instantiateDeserializationUtils();
        }
        try {
            for (i = 0; i < this.serializers.length; ++i) {
                this.deserializedFields1[i] = this.serializers[i].deserialize(this.deserializedFields1[i], firstSource);
                this.deserializedFields2[i] = this.serializers[i].deserialize(this.deserializedFields2[i], secondSource);
            }
            for (i = 0; i < this.keyPositions.length; ++i) {
                int keyPos = this.keyPositions[i];
                int cmp = this.comparators[i].compare(this.deserializedFields1[keyPos], this.deserializedFields2[keyPos]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i], (Throwable)iobex);
        }
    }

    public boolean supportsNormalizedKey() {
        return this.numLeadingNormalizableKeys > 0;
    }

    public int getNormalizeKeyLen() {
        return this.normalizableKeyPrefixLen;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.numLeadingNormalizableKeys < this.keyPositions.length || this.normalizableKeyPrefixLen == Integer.MAX_VALUE || this.normalizableKeyPrefixLen > keyBytes;
    }

    public boolean invertNormalizedKey() {
        return this.invertNormKey;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected final void instantiateDeserializationUtils() {
        int i;
        if (this.serializers == null) {
            this.serializers = new TypeSerializer[this.serializerFactories.length];
            for (i = 0; i < this.serializers.length; ++i) {
                this.serializers[i] = this.serializerFactories[i].getSerializer();
            }
        }
        this.deserializedFields1 = new Object[this.serializers.length];
        this.deserializedFields2 = new Object[this.serializers.length];
        for (i = 0; i < this.serializers.length; ++i) {
            this.deserializedFields1[i] = this.serializers[i].createInstance();
            this.deserializedFields2[i] = this.serializers[i].createInstance();
        }
    }
}

