/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;

public class CrossOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, CrossOperator<I1, I2, OUT>> {
    private final CrossFunction<I1, I2, OUT> function;

    public CrossOperator(DataSet<I1> input1, DataSet<I2> input2, CrossFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType) {
        super(input1, input2, returnType);
        this.function = function;
        if (!(function instanceof ProjectCrossFunction)) {
            this.extractSemanticAnnotationsFromUdf(function.getClass());
        } else {
            this.generateProjectionProperties((ProjectCrossFunction)function);
        }
    }

    public void generateProjectionProperties(ProjectCrossFunction<?, ?, ?> pcf) {
        DualInputSemanticProperties props = SemanticPropUtil.createProjectionPropertiesDual(pcf.getFields(), pcf.getIsFromFirst());
        this.setSemanticProperties(props);
    }

    @Override
    protected CrossOperatorBase<I1, I2, OUT, CrossFunction<I1, I2, OUT>> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
        String name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        CrossOperatorBase po = new CrossOperatorBase(this.function, new BinaryOperatorInformation(this.getInput1Type(), this.getInput2Type(), this.getResultType()), name);
        po.setFirstInput(input1);
        po.setSecondInput(input2);
        po.setDegreeOfParallelism(this.getParallelism());
        return po;
    }

    public static final class DefaultCrossFunction<T1, T2>
    implements CrossFunction<T1, T2, Tuple2<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final Tuple2<T1, T2> outTuple = new Tuple2();

        public Tuple2<T1, T2> cross(T1 first, T2 second) throws Exception {
            this.outTuple.f0 = first;
            this.outTuple.f1 = second;
            return this.outTuple;
        }
    }

    public static final class CrossProjection<I1, I2> {
        private final DataSet<I1> ds1;
        private final DataSet<I2> ds2;
        private int[] fieldIndexes;
        private boolean[] isFieldInFirst;
        private final int numFieldsDs1;
        private final int numFieldsDs2;

        public CrossProjection(DataSet<I1> ds1, DataSet<I2> ds2, int[] firstFieldIndexes, int[] secondFieldIndexes) {
            boolean isTuple;
            boolean firstInput;
            boolean isSecondTuple;
            boolean isFirstTuple;
            this.ds1 = ds1;
            this.ds2 = ds2;
            if (ds1.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs1 = ((TupleTypeInfo)ds1.getType()).getArity();
                isFirstTuple = true;
            } else {
                this.numFieldsDs1 = 1;
                isFirstTuple = false;
            }
            if (ds2.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs2 = ((TupleTypeInfo)ds2.getType()).getArity();
                isSecondTuple = true;
            } else {
                this.numFieldsDs2 = 1;
                isSecondTuple = false;
            }
            if (firstFieldIndexes != null && secondFieldIndexes == null) {
                firstInput = true;
                isTuple = isFirstTuple;
                this.fieldIndexes = firstFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else if (firstFieldIndexes == null && secondFieldIndexes != null) {
                firstInput = false;
                isTuple = isSecondTuple;
                this.fieldIndexes = secondFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else {
                if (firstFieldIndexes == null && secondFieldIndexes == null) {
                    throw new IllegalArgumentException("You must provide at least one field index array.");
                }
                throw new IllegalArgumentException("You must provide at most one field index array.");
            }
            if (!isTuple && this.fieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() (or projectSecond()) without arguments to include it.");
            }
            if (this.fieldIndexes.length > 22) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields.");
            }
            if (isTuple) {
                this.isFieldInFirst = new boolean[this.fieldIndexes.length];
                int maxFieldIndex = firstInput ? this.numFieldsDs1 : this.numFieldsDs2;
                for (int i = 0; i < this.fieldIndexes.length; ++i) {
                    if (this.fieldIndexes[i] > maxFieldIndex - 1) {
                        throw new IndexOutOfBoundsException("Provided field index is out of bounds of input tuple.");
                    }
                    this.isFieldInFirst[i] = firstInput;
                }
            } else {
                this.isFieldInFirst = new boolean[]{firstInput};
                this.fieldIndexes = new int[]{-1};
            }
        }

        public CrossProjection<I1, I2> projectFirst(int ... firstFieldIndexes) {
            boolean isFirstTuple = this.ds1.getType() instanceof TupleTypeInfo && firstFieldIndexes.length > 0;
            if (!isFirstTuple && firstFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() without arguments to include it.");
            }
            if (firstFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isFirstTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + firstFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + firstFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs1;
                for (int i = 0; i < firstFieldIndexes.length; ++i) {
                    if (firstFieldIndexes[i] > maxFieldIndex - 1) {
                        throw new IndexOutOfBoundsException("Provided field index is out of bounds of input tuple.");
                    }
                    this.isFieldInFirst[offset + i] = true;
                    this.fieldIndexes[offset + i] = firstFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = true;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        public CrossProjection<I1, I2> projectSecond(int ... secondFieldIndexes) {
            boolean isSecondTuple = this.ds2.getType() instanceof TupleTypeInfo && secondFieldIndexes.length > 0;
            if (!isSecondTuple && secondFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectSecond() without arguments to include it.");
            }
            if (secondFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isSecondTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + secondFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + secondFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs2;
                for (int i = 0; i < secondFieldIndexes.length; ++i) {
                    if (secondFieldIndexes[i] > maxFieldIndex - 1) {
                        throw new IndexOutOfBoundsException("Provided field index is out of bounds of input tuple.");
                    }
                    this.isFieldInFirst[offset + i] = false;
                    this.fieldIndexes[offset + i] = secondFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = false;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        public <T0> ProjectCross<I1, I2, Tuple1<T0>> types(Class<T0> type0) {
            Class[] types = new Class[]{type0};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1> ProjectCross<I1, I2, Tuple2<T0, T1>> types(Class<T0> type0, Class<T1> type1) {
            Class[] types = new Class[]{type0, type1};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2> ProjectCross<I1, I2, Tuple3<T0, T1, T2>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2) {
            Class[] types = new Class[]{type0, type1, type2};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3> ProjectCross<I1, I2, Tuple4<T0, T1, T2, T3>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3) {
            Class[] types = new Class[]{type0, type1, type2, type3};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4> ProjectCross<I1, I2, Tuple5<T0, T1, T2, T3, T4>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5> ProjectCross<I1, I2, Tuple6<T0, T1, T2, T3, T4, T5>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6> ProjectCross<I1, I2, Tuple7<T0, T1, T2, T3, T4, T5, T6>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7> ProjectCross<I1, I2, Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8> ProjectCross<I1, I2, Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> ProjectCross<I1, I2, Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ProjectCross<I1, I2, Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ProjectCross<I1, I2, Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ProjectCross<I1, I2, Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ProjectCross<I1, I2, Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ProjectCross<I1, I2, Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ProjectCross<I1, I2, Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ProjectCross<I1, I2, Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ProjectCross<I1, I2, Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ProjectCross<I1, I2, Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ProjectCross<I1, I2, Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ProjectCross<I1, I2, Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ProjectCross<I1, I2, Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ProjectCross<I1, I2, Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> ProjectCross<I1, I2, Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22, Class<T23> type23) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22, type23};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> ProjectCross<I1, I2, Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22, Class<T23> type23, Class<T24> type24) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22, type23, type24};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        private TypeInformation<?>[] extractFieldTypes(int[] fields, Class<?>[] givenTypes) {
            TypeInformation[] fieldTypes = new TypeInformation[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Object typeInfo = this.isFieldInFirst[i] ? (fields[i] >= 0 ? ((TupleTypeInfo)this.ds1.getType()).getTypeAt(fields[i]) : this.ds1.getType()) : (fields[i] >= 0 ? ((TupleTypeInfo)this.ds2.getType()).getTypeAt(fields[i]) : this.ds2.getType());
                if (typeInfo.getTypeClass() != givenTypes[i]) {
                    throw new IllegalArgumentException("Given types do not match types of input data set.");
                }
                fieldTypes[i] = typeInfo;
            }
            return fieldTypes;
        }
    }

    public static final class ProjectCrossFunction<T1, T2, R extends Tuple>
    implements CrossFunction<T1, T2, R> {
        private static final long serialVersionUID = 1L;
        private final int[] fields;
        private final boolean[] isFromFirst;
        private final R outTuple;

        private ProjectCrossFunction(int[] fields, boolean[] isFromFirst, R outTupleInstance) {
            if (fields.length != isFromFirst.length) {
                throw new IllegalArgumentException("Fields and isFromFirst arrays must have same length!");
            }
            this.fields = fields;
            this.isFromFirst = isFromFirst;
            this.outTuple = outTupleInstance;
        }

        public R cross(T1 in1, T2 in2) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.isFromFirst[i]) {
                    if (this.fields[i] >= 0) {
                        ((Tuple)this.outTuple).setField(((Tuple)in1).getField(this.fields[i]), i);
                        continue;
                    }
                    ((Tuple)this.outTuple).setField(in1, i);
                    continue;
                }
                if (this.fields[i] >= 0) {
                    ((Tuple)this.outTuple).setField(((Tuple)in2).getField(this.fields[i]), i);
                    continue;
                }
                ((Tuple)this.outTuple).setField(in2, i);
            }
            return this.outTuple;
        }

        protected int[] getFields() {
            return this.fields;
        }

        protected boolean[] getIsFromFirst() {
            return this.isFromFirst;
        }

        /* synthetic */ ProjectCrossFunction(int[] x0, boolean[] x1, Tuple x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static final class ProjectCross<I1, I2, OUT extends Tuple>
    extends CrossOperator<I1, I2, OUT> {
        protected ProjectCross(DataSet<I1> input1, DataSet<I2> input2, int[] fields, boolean[] isFromFirst, TupleTypeInfo<OUT> returnType) {
            super(input1, input2, new ProjectCrossFunction(fields, isFromFirst, (Tuple)returnType.createSerializer().createInstance(), null), returnType);
        }

        @Override
        public CrossOperator<I1, I2, OUT> withConstantSetFirst(String ... constantSetFirst) {
            throw new InvalidProgramException("The semantic properties (constant fields and forwarded fields) are automatically calculated.");
        }

        @Override
        public CrossOperator<I1, I2, OUT> withConstantSetSecond(String ... constantSetSecond) {
            throw new InvalidProgramException("The semantic properties (constant fields and forwarded fields) are automatically calculated.");
        }
    }

    public static final class DefaultCross<I1, I2>
    extends CrossOperator<I1, I2, Tuple2<I1, I2>> {
        private final DataSet<I1> input1;
        private final DataSet<I2> input2;

        public DefaultCross(DataSet<I1> input1, DataSet<I2> input2) {
            super(input1, input2, new DefaultCrossFunction(), new TupleTypeInfo(input1.getType(), input2.getType()));
            if (input1 == null || input2 == null) {
                throw new NullPointerException();
            }
            this.input1 = input1;
            this.input2 = input2;
        }

        public <R> CrossOperator<I1, I2, R> with(CrossFunction<I1, I2, R> function) {
            if (function == null) {
                throw new NullPointerException("Cross function must not be null.");
            }
            TypeInformation<R> returnType = TypeExtractor.getCrossReturnTypes(function, this.input1.getType(), this.input2.getType());
            return new CrossOperator<I1, I2, R>(this.input1, this.input2, function, returnType);
        }

        public CrossProjection<I1, I2> projectFirst(int ... firstFieldIndexes) {
            return new CrossProjection<I1, I2>(this.input1, this.input2, firstFieldIndexes, null);
        }

        public CrossProjection<I1, I2> projectSecond(int ... secondFieldIndexes) {
            return new CrossProjection<I1, I2>(this.input1, this.input2, null, secondFieldIndexes);
        }
    }
}

