/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.java.functions.InvalidTypesException;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.UnsupportedLambdaExpressionException;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.BasicArrayTypeInfo;
import org.apache.flink.api.java.typeutils.BasicTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.PrimitiveArrayTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;
import org.apache.flink.types.TypeInformation;
import org.apache.flink.types.Value;
import org.apache.hadoop.io.Writable;

public class TypeExtractor {
    private Set<Class<?>> alreadySeen = new HashSet();

    private TypeExtractor() {
    }

    public static <IN, OUT> TypeInformation<OUT> getMapReturnTypes(MapFunction<IN, OUT> mapInterface, TypeInformation<IN> inType) {
        TypeExtractor.validateInputType(MapFunction.class, mapInterface.getClass(), 0, inType);
        if (mapInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)mapInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(MapFunction.class, mapInterface.getClass(), 1, inType, null);
    }

    public static <IN, OUT> TypeInformation<OUT> getFlatMapReturnTypes(FlatMapFunction<IN, OUT> flatMapInterface, TypeInformation<IN> inType) {
        TypeExtractor.validateInputType(FlatMapFunction.class, flatMapInterface.getClass(), 0, inType);
        if (flatMapInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)flatMapInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(FlatMapFunction.class, flatMapInterface.getClass(), 1, inType, null);
    }

    public static <IN, OUT> TypeInformation<OUT> getGroupReduceReturnTypes(GroupReduceFunction<IN, OUT> groupReduceInterface, TypeInformation<IN> inType) {
        TypeExtractor.validateInputType(GroupReduceFunction.class, groupReduceInterface.getClass(), 0, inType);
        if (groupReduceInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)groupReduceInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(GroupReduceFunction.class, groupReduceInterface.getClass(), 1, inType, null);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getJoinReturnTypes(FlatJoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeExtractor.validateInputType(FlatJoinFunction.class, joinInterface.getClass(), 0, in1Type);
        TypeExtractor.validateInputType(FlatJoinFunction.class, joinInterface.getClass(), 1, in2Type);
        if (joinInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)joinInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(FlatJoinFunction.class, joinInterface.getClass(), 2, in1Type, in2Type);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getJoinReturnTypes(JoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeExtractor.validateInputType(JoinFunction.class, joinInterface.getClass(), 0, in1Type);
        TypeExtractor.validateInputType(JoinFunction.class, joinInterface.getClass(), 1, in2Type);
        if (joinInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)joinInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(JoinFunction.class, joinInterface.getClass(), 2, in1Type, in2Type);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getCoGroupReturnTypes(CoGroupFunction<IN1, IN2, OUT> coGroupInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeExtractor.validateInputType(CoGroupFunction.class, coGroupInterface.getClass(), 0, in1Type);
        TypeExtractor.validateInputType(CoGroupFunction.class, coGroupInterface.getClass(), 1, in2Type);
        if (coGroupInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)coGroupInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(CoGroupFunction.class, coGroupInterface.getClass(), 2, in1Type, in2Type);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getCrossReturnTypes(CrossFunction<IN1, IN2, OUT> crossInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeExtractor.validateInputType(CrossFunction.class, crossInterface.getClass(), 0, in1Type);
        TypeExtractor.validateInputType(CrossFunction.class, crossInterface.getClass(), 1, in2Type);
        if (crossInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)crossInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(CrossFunction.class, crossInterface.getClass(), 2, in1Type, in2Type);
    }

    public static <IN, OUT> TypeInformation<OUT> getKeySelectorTypes(KeySelector<IN, OUT> selectorInterface, TypeInformation<IN> inType) {
        if (FunctionUtils.isLambdaFunction(selectorInterface)) {
            throw new UnsupportedLambdaExpressionException();
        }
        TypeExtractor.validateInputType(KeySelector.class, selectorInterface.getClass(), 0, inType);
        if (selectorInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)((Object)selectorInterface)).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(KeySelector.class, selectorInterface.getClass(), 1, inType, null);
    }

    public static <IN> TypeInformation<IN> getInputFormatTypes(InputFormat<IN, ?> inputFormatInterface) {
        if (inputFormatInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)inputFormatInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(InputFormat.class, inputFormatInterface.getClass(), 0, null, null);
    }

    public static TypeInformation<?> createTypeInfo(Type t) {
        return new TypeExtractor().privateCreateTypeInfo(t);
    }

    private TypeInformation<?> privateCreateTypeInfo(Type t) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(t);
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, t, null, null);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfo(Class<?> baseClass, Class<?> clazz, int returnParamPos, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return new TypeExtractor().privateCreateTypeInfo(baseClass, clazz, returnParamPos, in1Type, in2Type);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> privateCreateTypeInfo(Class<?> baseClass, Class<?> clazz, int returnParamPos, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        Type returnType = TypeExtractor.getParameterType(baseClass, typeHierarchy, clazz, returnParamPos);
        TypeInformation<?> typeInfo = null;
        if (returnType instanceof TypeVariable && (typeInfo = this.createTypeInfoFromInput((TypeVariable)returnType, typeHierarchy, in1Type, in2Type)) != null) {
            return typeInfo;
        }
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, returnType, in1Type, in2Type);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfoWithTypeHierarchy(ArrayList<Type> typeHierarchy, Type t, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        if (t instanceof Class && Tuple.class.isAssignableFrom((Class)t) || t instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) {
            Type curT = t;
            if (curT instanceof Class && ((Class)curT).equals(Tuple.class)) {
                throw new InvalidTypesException("Usage of class Tuple as a type is not allowed. Use a concrete subclass (e.g. Tuple1, Tuple2, etc.) instead.");
            }
            while (!(curT instanceof ParameterizedType && ((Class)((ParameterizedType)curT).getRawType()).getSuperclass().equals(Tuple.class) || curT instanceof Class && ((Class)curT).getSuperclass().equals(Tuple.class))) {
                typeHierarchy.add(curT);
                if (curT instanceof ParameterizedType) {
                    curT = ((Class)((ParameterizedType)curT).getRawType()).getGenericSuperclass();
                    continue;
                }
                curT = ((Class)curT).getGenericSuperclass();
            }
            if (curT instanceof Class) {
                throw new InvalidTypesException("Tuple needs to be parameterized by using generics.");
            }
            ParameterizedType tupleChild = (ParameterizedType)curT;
            Type[] subtypes = new Type[tupleChild.getActualTypeArguments().length];
            for (int i = 0; i < subtypes.length; ++i) {
                subtypes[i] = tupleChild.getActualTypeArguments()[i] instanceof TypeVariable ? TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)tupleChild.getActualTypeArguments()[i]) : tupleChild.getActualTypeArguments()[i];
            }
            TypeInformation[] tupleSubTypes = new TypeInformation[subtypes.length];
            for (int i = 0; i < subtypes.length; ++i) {
                if (subtypes[i] instanceof TypeVariable) {
                    tupleSubTypes[i] = this.createTypeInfoFromInput((TypeVariable)subtypes[i], typeHierarchy, in1Type, in2Type);
                    if (tupleSubTypes[i] != null) continue;
                    throw new InvalidTypesException("Type of TypeVariable '" + ((TypeVariable)subtypes[i]).getName() + "' in '" + ((TypeVariable)subtypes[i]).getGenericDeclaration() + "' could not be determined. This is most likely a type erasure problem. " + "The type extraction currently supports types with generic variables only in cases where " + "all variables in the return type can be deduced from the input type(s).");
                }
                tupleSubTypes[i] = this.createTypeInfoWithTypeHierarchy(new ArrayList<Type>(typeHierarchy), subtypes[i], in1Type, in2Type);
            }
            if (t instanceof Class) {
                return new TupleTypeInfo((Class)t, tupleSubTypes);
            }
            if (t instanceof ParameterizedType) {
                return new TupleTypeInfo((Class)((ParameterizedType)t).getRawType(), tupleSubTypes);
            }
        } else {
            if (t instanceof TypeVariable) {
                Type typeVar = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)t);
                if (!(typeVar instanceof TypeVariable)) {
                    return this.createTypeInfoWithTypeHierarchy(typeHierarchy, typeVar, in1Type, in2Type);
                }
                TypeInformation<?> typeInfo = this.createTypeInfoFromInput((TypeVariable)t, typeHierarchy, in1Type, in2Type);
                if (typeInfo != null) {
                    return typeInfo;
                }
                throw new InvalidTypesException("Type of TypeVariable '" + ((TypeVariable)t).getName() + "' in '" + ((TypeVariable)t).getGenericDeclaration() + "' could not be determined. This is most likely a type erasure problem. " + "The type extraction currently supports types with generic variables only in cases where " + "all variables in the return type can be deduced from the input type(s).");
            }
            if (t instanceof GenericArrayType) {
                GenericArrayType genericArray = (GenericArrayType)t;
                Type componentType = genericArray.getGenericComponentType();
                if (componentType instanceof Class) {
                    Class componentClass = (Class)componentType;
                    String className = componentClass.isPrimitive() ? TypeExtractor.encodePrimitiveClass(componentClass) : "L" + componentClass.getName() + ";";
                    Class<?> classArray = null;
                    try {
                        classArray = Class.forName("[" + className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new InvalidTypesException("Could not convert GenericArrayType to Class.");
                    }
                    return TypeExtractor.getForClass(classArray);
                }
                TypeInformation<OUT> componentInfo = this.createTypeInfoWithTypeHierarchy(typeHierarchy, genericArray.getGenericComponentType(), in1Type, in2Type);
                return ObjectArrayTypeInfo.getInfoFor(t, componentInfo);
            }
            if (t instanceof ParameterizedType) {
                return this.privateGetForClass((Class)((ParameterizedType)t).getRawType());
            }
            if (t instanceof Class) {
                return this.privateGetForClass((Class)t);
            }
        }
        throw new InvalidTypesException("Type Information could not be created.");
    }

    private <IN1, IN2> TypeInformation<?> createTypeInfoFromInput(TypeVariable<?> returnTypeVar, ArrayList<Type> returnTypeHierarchy, TypeInformation<IN1> in1TypeInfo, TypeInformation<IN2> in2TypeInfo) {
        Type in2Type;
        ParameterizedType baseClass;
        Type in1Type;
        Type matReturnTypeVar = TypeExtractor.materializeTypeVariable(returnTypeHierarchy, returnTypeVar);
        if (!(matReturnTypeVar instanceof TypeVariable)) {
            return this.createTypeInfoWithTypeHierarchy(returnTypeHierarchy, matReturnTypeVar, in1TypeInfo, in2TypeInfo);
        }
        returnTypeVar = (TypeVariable)matReturnTypeVar;
        TypeInformation<?> info = null;
        if (in1TypeInfo != null && (in1Type = (baseClass = (ParameterizedType)returnTypeHierarchy.get(returnTypeHierarchy.size() - 1)).getActualTypeArguments()[0]) instanceof TypeVariable) {
            in1Type = TypeExtractor.materializeTypeVariable(returnTypeHierarchy, (TypeVariable)in1Type);
            info = TypeExtractor.findCorrespondingInfo(returnTypeVar, in1Type, in1TypeInfo);
        }
        if (info == null && in2TypeInfo != null && (in2Type = (baseClass = (ParameterizedType)returnTypeHierarchy.get(returnTypeHierarchy.size() - 1)).getActualTypeArguments()[1]) instanceof TypeVariable) {
            in2Type = TypeExtractor.materializeTypeVariable(returnTypeHierarchy, (TypeVariable)in2Type);
            info = TypeExtractor.findCorrespondingInfo(returnTypeVar, in2Type, in2TypeInfo);
        }
        if (info != null) {
            return info;
        }
        return null;
    }

    public static Type getParameterType(Class<?> baseClass, Class<?> clazz, int pos) {
        return TypeExtractor.getParameterType(baseClass, null, clazz, pos);
    }

    private static Type getParameterType(Class<?> baseClass, ArrayList<Type> typeHierarchy, Class<?> clazz, int pos) {
        Type[] interfaceTypes;
        for (Type t : interfaceTypes = clazz.getGenericInterfaces()) {
            Type parameter = TypeExtractor.getParameterTypeFromGenericType(baseClass, typeHierarchy, t, pos);
            if (parameter == null) continue;
            return parameter;
        }
        Type t = clazz.getGenericSuperclass();
        Type parameter = TypeExtractor.getParameterTypeFromGenericType(baseClass, typeHierarchy, t, pos);
        if (parameter != null) {
            return parameter;
        }
        throw new IllegalArgumentException("The types of the interface " + baseClass.getName() + " could not be inferred. " + "Support for synthetic interfaces, lambdas, and generic types is limited at this point.");
    }

    private static Type getParameterTypeFromGenericType(Class<?> baseClass, ArrayList<Type> typeHierarchy, Type t, int pos) {
        if (t instanceof ParameterizedType && baseClass.equals((Class)((ParameterizedType)t).getRawType())) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            ParameterizedType baseClassChild = (ParameterizedType)t;
            return baseClassChild.getActualTypeArguments()[pos];
        }
        if (t instanceof ParameterizedType && baseClass.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            return TypeExtractor.getParameterType(baseClass, typeHierarchy, (Class)((ParameterizedType)t).getRawType(), pos);
        }
        if (t instanceof Class && baseClass.isAssignableFrom((Class)t)) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            return TypeExtractor.getParameterType(baseClass, typeHierarchy, (Class)t, pos);
        }
        return null;
    }

    private static void validateInputType(Class<?> baseClass, Class<?> clazz, int inputParamPos, TypeInformation<?> inType) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        try {
            TypeExtractor.validateInfo(typeHierarchy, TypeExtractor.getParameterType(baseClass, typeHierarchy, clazz, inputParamPos), inType);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Input mismatch: " + e.getMessage());
        }
    }

    private static void validateInfo(ArrayList<Type> typeHierarchy, Type type, TypeInformation<?> typeInfo) {
        block28: {
            block26: {
                Class clazz;
                block36: {
                    block34: {
                        Class clazz2;
                        block35: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block27: {
                                                    if (type == null) {
                                                        throw new InvalidTypesException("Unknown Error. Type is null.");
                                                    }
                                                    if (typeInfo == null) {
                                                        throw new InvalidTypesException("Unknown Error. TypeInformation is null.");
                                                    }
                                                    if (type instanceof TypeVariable) break block26;
                                                    if (!typeInfo.isBasicType()) break block27;
                                                    BasicTypeInfo actual = null;
                                                    if (!(type instanceof Class) || (actual = BasicTypeInfo.getInfoFor((Class)type)) == null) {
                                                        throw new InvalidTypesException("Basic type expected.");
                                                    }
                                                    if (!typeInfo.equals(actual)) {
                                                        throw new InvalidTypesException("Basic type '" + typeInfo + "' expected but was '" + actual + "'.");
                                                    }
                                                    break block28;
                                                }
                                                if (!typeInfo.isTupleType()) break block29;
                                                if (!(type instanceof Class && Tuple.class.isAssignableFrom((Class)type) || type instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()))) {
                                                    throw new InvalidTypesException("Tuple type expected.");
                                                }
                                                if (type instanceof Class && ((Class)type).equals(Tuple.class)) {
                                                    throw new InvalidTypesException("Concrete subclass of Tuple expected.");
                                                }
                                                while (!(type instanceof ParameterizedType && ((Class)((ParameterizedType)type).getRawType()).getSuperclass().equals(Tuple.class) || type instanceof Class && ((Class)type).getSuperclass().equals(Tuple.class))) {
                                                    typeHierarchy.add(type);
                                                    if (type instanceof ParameterizedType) {
                                                        type = ((Class)((ParameterizedType)type).getRawType()).getGenericSuperclass();
                                                        continue;
                                                    }
                                                    type = ((Class)type).getGenericSuperclass();
                                                }
                                                if (type instanceof Class) {
                                                    throw new InvalidTypesException("Parameterized Tuple type expected.");
                                                }
                                                TupleTypeInfo tti = (TupleTypeInfo)typeInfo;
                                                Type[] subTypes = ((ParameterizedType)type).getActualTypeArguments();
                                                if (subTypes.length != tti.getArity()) {
                                                    throw new InvalidTypesException("Tuple arity '" + tti.getArity() + "' expected but was '" + subTypes.length + "'.");
                                                }
                                                for (int i = 0; i < subTypes.length; ++i) {
                                                    TypeExtractor.validateInfo(new ArrayList<Type>(typeHierarchy), subTypes[i], ((TupleTypeInfo)typeInfo).getTypeAt(i));
                                                }
                                                break block28;
                                            }
                                            if (!(typeInfo instanceof WritableTypeInfo)) break block30;
                                            if (!(type instanceof Class) || !Writable.class.isAssignableFrom((Class)type)) {
                                                throw new InvalidTypesException("Writable type expected.");
                                            }
                                            Class clazz3 = null;
                                            clazz3 = (Class)type;
                                            if (((WritableTypeInfo)typeInfo).getTypeClass() != clazz3) {
                                                throw new InvalidTypesException("Writable type '" + ((WritableTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz3.getCanonicalName() + "'.");
                                            }
                                            break block28;
                                        }
                                        if (!(typeInfo instanceof BasicArrayTypeInfo)) break block31;
                                        Type component = null;
                                        if (!(type instanceof Class && ((Class)type).isArray() && (component = ((Class)type).getComponentType()) != null || type instanceof GenericArrayType && (component = ((GenericArrayType)type).getGenericComponentType()) != null)) {
                                            throw new InvalidTypesException("Array type expected.");
                                        }
                                        if (component instanceof TypeVariable && (component = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component)) instanceof TypeVariable) {
                                            return;
                                        }
                                        TypeExtractor.validateInfo(typeHierarchy, component, ((BasicArrayTypeInfo)typeInfo).getComponentInfo());
                                        break block28;
                                    }
                                    if (!(typeInfo instanceof ObjectArrayTypeInfo)) break block32;
                                    if (!(type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType)) {
                                        throw new InvalidTypesException("Object array type expected.");
                                    }
                                    Type component = null;
                                    component = type instanceof Class ? ((Class)type).getComponentType() : ((GenericArrayType)type).getGenericComponentType();
                                    if (component instanceof TypeVariable && (component = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component)) instanceof TypeVariable) {
                                        return;
                                    }
                                    TypeExtractor.validateInfo(typeHierarchy, component, ((ObjectArrayTypeInfo)typeInfo).getComponentInfo());
                                    break block28;
                                }
                                if (!(typeInfo instanceof ValueTypeInfo)) break block33;
                                if (!(type instanceof Class) || !Value.class.isAssignableFrom((Class)type)) {
                                    throw new InvalidTypesException("Value type expected.");
                                }
                                TypeInformation actual = null;
                                actual = ValueTypeInfo.getValueTypeInfo((Class)type);
                                if (!((ValueTypeInfo)typeInfo).equals(actual)) {
                                    throw new InvalidTypesException("Value type '" + typeInfo + "' expected but was '" + actual + "'.");
                                }
                                break block28;
                            }
                            if (!(typeInfo instanceof PojoTypeInfo)) break block34;
                            clazz2 = null;
                            if (!(type instanceof Class)) break block35;
                            clazz2 = (Class)type;
                            if (((PojoTypeInfo)typeInfo).getTypeClass() == clazz2) break block28;
                        }
                        if (!(type instanceof ParameterizedType) || (clazz2 = (Class)((ParameterizedType)type).getRawType()) != ((PojoTypeInfo)typeInfo).getTypeClass()) {
                            throw new InvalidTypesException("POJO type '" + ((PojoTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz2.getCanonicalName() + "'.");
                        }
                        break block28;
                    }
                    if (!(typeInfo instanceof GenericTypeInfo)) break block28;
                    clazz = null;
                    if (!(type instanceof Class)) break block36;
                    clazz = (Class)type;
                    if (((GenericTypeInfo)typeInfo).getTypeClass() == clazz) break block28;
                }
                if (!(type instanceof ParameterizedType) || (clazz = (Class)((ParameterizedType)type).getRawType()) != ((GenericTypeInfo)typeInfo).getTypeClass()) {
                    throw new InvalidTypesException("Generic object type '" + ((GenericTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz.getCanonicalName() + "'.");
                }
                break block28;
            }
            if (!((type = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)type)) instanceof TypeVariable)) {
                TypeExtractor.validateInfo(typeHierarchy, type, typeInfo);
            }
        }
    }

    private static String encodePrimitiveClass(Class<?> primitiveClass) {
        String name = primitiveClass.getName();
        if (name.equals("boolean")) {
            return "Z";
        }
        if (name.equals("byte")) {
            return "B";
        }
        if (name.equals("char")) {
            return "C";
        }
        if (name.equals("double")) {
            return "D";
        }
        if (name.equals("float")) {
            return "F";
        }
        if (name.equals("int")) {
            return "I";
        }
        if (name.equals("long")) {
            return "J";
        }
        if (name.equals("short")) {
            return "S";
        }
        throw new InvalidTypesException();
    }

    private static TypeInformation<?> findCorrespondingInfo(TypeVariable<?> typeVar, Type type, TypeInformation<?> corrInfo) {
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            if (variable.getName().equals(typeVar.getName()) && variable.getGenericDeclaration().equals(typeVar.getGenericDeclaration())) {
                return corrInfo;
            }
        } else if (type instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
            ParameterizedType tuple = (ParameterizedType)type;
            Type[] args = tuple.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                TypeInformation<?> info = TypeExtractor.findCorrespondingInfo(typeVar, args[i], ((TupleTypeInfo)corrInfo).getTypeAt(i));
                if (info == null) continue;
                return info;
            }
        }
        return null;
    }

    private static Type materializeTypeVariable(ArrayList<Type> typeHierarchy, TypeVariable<?> typeVar) {
        TypeVariable inTypeTypeVar = typeVar;
        for (int i = typeHierarchy.size() - 1; i >= 0; --i) {
            Type curT = typeHierarchy.get(i);
            if (!(curT instanceof ParameterizedType)) continue;
            Class rawType = (Class)((ParameterizedType)curT).getRawType();
            for (int paramIndex = 0; paramIndex < rawType.getTypeParameters().length; ++paramIndex) {
                TypeVariable curVarOfCurT = rawType.getTypeParameters()[paramIndex];
                if (!curVarOfCurT.getName().equals(inTypeTypeVar.getName()) || !curVarOfCurT.getGenericDeclaration().equals(inTypeTypeVar.getGenericDeclaration())) continue;
                Type curVarType = ((ParameterizedType)curT).getActualTypeArguments()[paramIndex];
                if (curVarType instanceof TypeVariable) {
                    inTypeTypeVar = (TypeVariable)curVarType;
                    continue;
                }
                return curVarType;
            }
        }
        return inTypeTypeVar;
    }

    public static <X> TypeInformation<X> getForClass(Class<X> clazz) {
        return new TypeExtractor().privateGetForClass(clazz);
    }

    private <X> TypeInformation<X> privateGetForClass(Class<X> clazz) {
        Validate.notNull(clazz);
        if (!clazz.isPrimitive() && (Modifier.isInterface(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers()) && !clazz.isArray())) {
            throw new InvalidTypesException("Interfaces and abstract classes are not valid types: " + clazz);
        }
        if (clazz.equals(Object.class)) {
            throw new InvalidTypesException("Object is not a valid type.");
        }
        if (clazz.isArray()) {
            PrimitiveArrayTypeInfo<X> primitiveArrayInfo = PrimitiveArrayTypeInfo.getInfoFor(clazz);
            if (primitiveArrayInfo != null) {
                return primitiveArrayInfo;
            }
            BasicArrayTypeInfo basicArrayInfo = BasicArrayTypeInfo.getInfoFor(clazz);
            if (basicArrayInfo != null) {
                return basicArrayInfo;
            }
            return ObjectArrayTypeInfo.getInfoFor(clazz);
        }
        if (Writable.class.isAssignableFrom(clazz)) {
            return WritableTypeInfo.getWritableTypeInfo(clazz);
        }
        BasicTypeInfo<X> basicTypeInfo = BasicTypeInfo.getInfoFor(clazz);
        if (basicTypeInfo != null) {
            return basicTypeInfo;
        }
        if (Value.class.isAssignableFrom(clazz)) {
            Class<Value> valueClass = clazz.asSubclass(Value.class);
            return ValueTypeInfo.getValueTypeInfo(valueClass);
        }
        if (Tuple.class.isAssignableFrom(clazz)) {
            throw new InvalidTypesException("Type information extraction for tuples cannot be done based on the class.");
        }
        if (this.alreadySeen.contains(clazz)) {
            return new GenericTypeInfo<X>(clazz);
        }
        this.alreadySeen.add(clazz);
        if (clazz.equals(Class.class)) {
            return new GenericTypeInfo<X>(clazz);
        }
        return new GenericTypeInfo<X>(clazz);
    }

    private <X> TypeInformation<X> analyzePojo(Class<X> clazz) {
        List<Field> fields = TypeExtractor.getAllDeclaredFields(clazz);
        ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
        for (Field field : fields) {
            try {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                pojoFields.add(new PojoField(field, this.privateCreateTypeInfo(field.getType())));
            }
            catch (InvalidTypesException e) {
                return new GenericTypeInfo<X>(clazz);
            }
        }
        PojoTypeInfo<X> pojoType = new PojoTypeInfo<X>(clazz, pojoFields);
        List<Method> methods = TypeExtractor.getAllDeclaredMethods(clazz);
        boolean containsReadObjectOrWriteObject = false;
        for (Method method : methods) {
            if (!method.getName().equals("readObject") && !method.getName().equals("writeObject")) continue;
            containsReadObjectOrWriteObject = true;
            break;
        }
        boolean hasDefaultCtor = true;
        try {
            clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            hasDefaultCtor = false;
        }
        if (!containsReadObjectOrWriteObject && hasDefaultCtor) {
            return pojoType;
        }
        return null;
    }

    private static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private static List<Method> getAllDeclaredMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (clazz != null) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                result.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static <X> TypeInformation<X> getForObject(X value) {
        return new TypeExtractor().privateGetForObject(value);
    }

    private <X> TypeInformation<X> privateGetForObject(X value) {
        Validate.notNull(value);
        if (value instanceof Tuple) {
            Tuple t = (Tuple)value;
            int numFields = t.getArity();
            TypeInformation[] infos = new TypeInformation[numFields];
            for (int i = 0; i < numFields; ++i) {
                Object field = t.getField(i);
                if (field == null) {
                    throw new InvalidTypesException("Automatic type extraction is not possible on candidates with null values. Please specify the types directly.");
                }
                infos[i] = this.privateGetForObject(field);
            }
            return new TupleTypeInfo(value.getClass(), infos);
        }
        return this.privateGetForClass(value.getClass());
    }
}

