/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanComparator;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteComparator;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.CharComparator;
import org.apache.flink.api.common.typeutils.base.CharSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleComparator;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatComparator;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.ShortComparator;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.StringComparator;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.AtomicType;
import org.apache.flink.types.TypeInformation;

public class BasicTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    public static final BasicTypeInfo<String> STRING_TYPE_INFO = new BasicTypeInfo<String>(String.class, (TypeSerializer<String>)StringSerializer.INSTANCE, (Class<TypeComparator<String>>)StringComparator.class);
    public static final BasicTypeInfo<Boolean> BOOLEAN_TYPE_INFO = new BasicTypeInfo<Boolean>(Boolean.class, (TypeSerializer<Boolean>)BooleanSerializer.INSTANCE, (Class<TypeComparator<Boolean>>)BooleanComparator.class);
    public static final BasicTypeInfo<Byte> BYTE_TYPE_INFO = new BasicTypeInfo<Byte>(Byte.class, (TypeSerializer<Byte>)ByteSerializer.INSTANCE, (Class<TypeComparator<Byte>>)ByteComparator.class);
    public static final BasicTypeInfo<Short> SHORT_TYPE_INFO = new BasicTypeInfo<Short>(Short.class, (TypeSerializer<Short>)ShortSerializer.INSTANCE, (Class<TypeComparator<Short>>)ShortComparator.class);
    public static final BasicTypeInfo<Integer> INT_TYPE_INFO = new BasicTypeInfo<Integer>(Integer.class, (TypeSerializer<Integer>)IntSerializer.INSTANCE, (Class<TypeComparator<Integer>>)IntComparator.class);
    public static final BasicTypeInfo<Long> LONG_TYPE_INFO = new BasicTypeInfo<Long>(Long.class, (TypeSerializer<Long>)LongSerializer.INSTANCE, (Class<TypeComparator<Long>>)LongComparator.class);
    public static final BasicTypeInfo<Float> FLOAT_TYPE_INFO = new BasicTypeInfo<Float>(Float.class, (TypeSerializer<Float>)FloatSerializer.INSTANCE, (Class<TypeComparator<Float>>)FloatComparator.class);
    public static final BasicTypeInfo<Double> DOUBLE_TYPE_INFO = new BasicTypeInfo<Double>(Double.class, (TypeSerializer<Double>)DoubleSerializer.INSTANCE, (Class<TypeComparator<Double>>)DoubleComparator.class);
    public static final BasicTypeInfo<Character> CHAR_TYPE_INFO = new BasicTypeInfo<Character>(Character.class, (TypeSerializer<Character>)CharSerializer.INSTANCE, (Class<TypeComparator<Character>>)CharComparator.class);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final Class<? extends TypeComparator<T>> comparatorClass;
    private static final Map<Class<?>, BasicTypeInfo<?>> TYPES = new HashMap();

    private BasicTypeInfo(Class<T> clazz, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        this.clazz = clazz;
        this.serializer = serializer;
        this.comparatorClass = comparatorClass;
    }

    public boolean isBasicType() {
        return true;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.clazz;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<T> createSerializer() {
        return this.serializer;
    }

    @Override
    public TypeComparator<T> createComparator(boolean sortOrderAscending) {
        return BasicTypeInfo.instantiateComparator(this.comparatorClass, sortOrderAscending);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicTypeInfo) {
            BasicTypeInfo other = (BasicTypeInfo)obj;
            return this.clazz.equals(other.clazz);
        }
        return false;
    }

    public String toString() {
        return this.clazz.getSimpleName();
    }

    public static <X> BasicTypeInfo<X> getInfoFor(Class<X> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        BasicTypeInfo<?> info = TYPES.get(type);
        return info;
    }

    private static <X> TypeComparator<X> instantiateComparator(Class<? extends TypeComparator<X>> comparatorClass, boolean ascendingOrder) {
        try {
            Constructor<TypeComparator<X>> constructor = comparatorClass.getConstructor(Boolean.TYPE);
            return constructor.newInstance(ascendingOrder);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize basic comparator " + comparatorClass.getName(), e);
        }
    }

    static {
        TYPES.put(String.class, STRING_TYPE_INFO);
        TYPES.put(Boolean.class, BOOLEAN_TYPE_INFO);
        TYPES.put(Boolean.TYPE, BOOLEAN_TYPE_INFO);
        TYPES.put(Byte.class, BYTE_TYPE_INFO);
        TYPES.put(Byte.TYPE, BYTE_TYPE_INFO);
        TYPES.put(Short.class, SHORT_TYPE_INFO);
        TYPES.put(Short.TYPE, SHORT_TYPE_INFO);
        TYPES.put(Integer.class, INT_TYPE_INFO);
        TYPES.put(Integer.TYPE, INT_TYPE_INFO);
        TYPES.put(Long.class, LONG_TYPE_INFO);
        TYPES.put(Long.TYPE, LONG_TYPE_INFO);
        TYPES.put(Float.class, FLOAT_TYPE_INFO);
        TYPES.put(Float.TYPE, FLOAT_TYPE_INFO);
        TYPES.put(Double.class, DOUBLE_TYPE_INFO);
        TYPES.put(Double.TYPE, DOUBLE_TYPE_INFO);
        TYPES.put(Character.class, CHAR_TYPE_INFO);
        TYPES.put(Character.TYPE, CHAR_TYPE_INFO);
    }
}

