/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.TwoInputOperator;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.TypeInformation;

public abstract class TwoInputUdfOperator<IN1, IN2, OUT, O extends TwoInputUdfOperator<IN1, IN2, OUT, O>>
extends TwoInputOperator<IN1, IN2, OUT, O>
implements UdfOperator<O> {
    private Configuration parameters;
    private Map<String, DataSet<?>> broadcastVariables;
    private DualInputSemanticProperties udfSemantics;

    protected TwoInputUdfOperator(DataSet<IN1> input1, DataSet<IN2> input2, TypeInformation<OUT> resultType) {
        super(input1, input2, resultType);
    }

    protected void extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
        Set<Annotation> annotations = FunctionAnnotation.readDualConstantAnnotations(udfClass);
        DualInputSemanticProperties dsp = SemanticPropUtil.getSemanticPropsDual(annotations, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        this.setSemanticProperties(dsp);
    }

    @Override
    public O withParameters(Configuration parameters) {
        this.parameters = parameters;
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public O withBroadcastSet(DataSet<?> data, String name) {
        if (this.broadcastVariables == null) {
            this.broadcastVariables = new HashMap();
        }
        this.broadcastVariables.put(name, data);
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withConstantSetFirst(String ... constantSetFirst) {
        if (this.udfSemantics == null) {
            this.udfSemantics = new DualInputSemanticProperties();
        }
        SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, constantSetFirst, null, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withConstantSetSecond(String ... constantSetSecond) {
        if (this.udfSemantics == null) {
            this.udfSemantics = new DualInputSemanticProperties();
        }
        SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, null, constantSetSecond, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public Map<String, DataSet<?>> getBroadcastSets() {
        return this.broadcastVariables == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.broadcastVariables);
    }

    @Override
    public Configuration getParameters() {
        return this.parameters;
    }

    public DualInputSemanticProperties getSematicProperties() {
        return this.udfSemantics;
    }

    public void setSemanticProperties(DualInputSemanticProperties properties) {
        this.udfSemantics = properties;
    }
}

