/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.java.tuple.Tuple;

public class TuplePairComparator<T1 extends Tuple, T2 extends Tuple>
extends TypePairComparator<T1, T2>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] keyFields1;
    private final int[] keyFields2;
    private final TypeComparator<Object>[] comparators1;
    private final TypeComparator<Object>[] comparators2;

    public TuplePairComparator(int[] keyFields1, int[] keyFields2, TypeComparator<Object>[] comparators1, TypeComparator<Object>[] comparators2) {
        if (keyFields1.length != keyFields2.length || keyFields1.length != comparators1.length || keyFields2.length != comparators2.length) {
            throw new IllegalArgumentException("Number of key fields and comparators differ.");
        }
        int numKeys = keyFields1.length;
        this.keyFields1 = keyFields1;
        this.keyFields2 = keyFields2;
        this.comparators1 = new TypeComparator[numKeys];
        this.comparators2 = new TypeComparator[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            this.comparators1[i] = comparators1[i].duplicate();
            this.comparators2[i] = comparators2[i].duplicate();
        }
    }

    public void setReference(T1 reference) {
        for (int i = 0; i < this.comparators1.length; ++i) {
            this.comparators1[i].setReference(((Tuple)reference).getField(this.keyFields1[i]));
        }
    }

    public boolean equalToReference(T2 candidate) {
        for (int i = 0; i < this.comparators1.length; ++i) {
            if (this.comparators1[i].equalToReference(((Tuple)candidate).getField(this.keyFields2[i]))) continue;
            return false;
        }
        return true;
    }

    public int compareToReference(T2 candidate) {
        for (int i = 0; i < this.comparators1.length; ++i) {
            this.comparators2[i].setReference(((Tuple)candidate).getField(this.keyFields2[i]));
            int res = this.comparators1[i].compareToReference(this.comparators2[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

