/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.common.operators.CompilerHints;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.types.parser.FieldParser;

public class CsvInputFormat
extends GenericCsvInputFormat<Record> {
    private static final long serialVersionUID = 1L;
    private transient Value[] parsedValues;
    private int[] targetPositions = new int[0];
    private boolean configured = false;
    private boolean lineDelimiterIsLinebreak = false;
    private static final String FIELD_DELIMITER_PARAMETER = "recordinformat.delimiter.field";
    private static final String NUM_FIELDS_PARAMETER = "recordinformat.field.number";
    private static final String FIELD_TYPE_PARAMETER_PREFIX = "recordinformat.field.type_";
    private static final String TEXT_POSITION_PARAMETER_PREFIX = "recordinformat.text.position_";

    public CsvInputFormat() {
    }

    public CsvInputFormat(char fieldDelimiter) {
        this.setFieldDelimiter(fieldDelimiter);
    }

    public CsvInputFormat(Class<? extends Value> ... fields) {
        this.setFieldTypes(fields);
    }

    public CsvInputFormat(char fieldDelimiter, Class<? extends Value> ... fields) {
        this.setFieldDelimiter(fieldDelimiter);
        this.setFieldTypes(fields);
    }

    public void setFieldTypesArray(Class<? extends Value>[] fieldTypes) {
        this.setFieldTypes(fieldTypes);
    }

    public void setFieldTypes(Class<? extends Value> ... fieldTypes) {
        if (fieldTypes == null) {
            throw new IllegalArgumentException("Field types must not be null.");
        }
        for (Class<? extends Value> type : fieldTypes) {
            if (type == null || Value.class.isAssignableFrom(type)) continue;
            throw new IllegalArgumentException("The types must be subclasses if " + Value.class.getName());
        }
        this.setFieldTypesGeneric(fieldTypes);
    }

    public void setFields(int[] sourceFieldIndices, Class<? extends Value>[] fieldTypes) {
        Preconditions.checkNotNull(fieldTypes);
        for (Class<? extends Value> type : fieldTypes) {
            if (Value.class.isAssignableFrom(type)) continue;
            throw new IllegalArgumentException("The types must be subclasses if " + Value.class.getName());
        }
        this.setFieldsGeneric(sourceFieldIndices, fieldTypes);
    }

    public void configure(Configuration config) {
        int numConfigFields;
        super.configure(config);
        if (this.configured) {
            return;
        }
        String fieldDelimStr = config.getString(FIELD_DELIMITER_PARAMETER, null);
        if (fieldDelimStr != null) {
            if (fieldDelimStr.length() != 1) {
                throw new IllegalArgumentException("Invalid configuration for CsvInputFormat: Field delimiter must be a single character");
            }
            this.setFieldDelimiter(fieldDelimStr.charAt(0));
        }
        if ((numConfigFields = config.getInteger(NUM_FIELDS_PARAMETER, -1)) != -1) {
            if (numConfigFields <= 0) {
                throw new IllegalConfigurationException("The number of fields for the CsvInputFormat is invalid.");
            }
            if (this.getNumberOfNonNullFields() > 0) {
                throw new IllegalConfigurationException("Mixing configuration via instance parameters and config parameters is not possible.");
            }
            int[] textPosIdx = new int[numConfigFields];
            boolean anyTextPosSet = false;
            boolean allTextPosSet = true;
            int maxTextPos = -1;
            for (int i = 0; i < numConfigFields; ++i) {
                int pos = config.getInteger(TEXT_POSITION_PARAMETER_PREFIX + i, -1);
                if (pos == -1) {
                    allTextPosSet = false;
                    textPosIdx[i] = i;
                    maxTextPos = i;
                    continue;
                }
                anyTextPosSet = true;
                textPosIdx[i] = pos;
                maxTextPos = pos > maxTextPos ? pos : maxTextPos;
            }
            if (anyTextPosSet && !allTextPosSet) {
                throw new IllegalArgumentException("Invalid configuration for CsvInputFormat: Not all text positions set");
            }
            Class[] types = new Class[maxTextPos + 1];
            int[] targetPos = new int[maxTextPos + 1];
            int i = 0;
            while (i < numConfigFields) {
                int pos = textPosIdx[i];
                Class<Value> clazz = config.getClass(FIELD_TYPE_PARAMETER_PREFIX + i, null).asSubclass(Value.class);
                if (clazz == null) {
                    throw new IllegalConfigurationException("Invalid configuration for CsvInputFormat: No field parser class for parameter " + i);
                }
                types[pos] = clazz;
                targetPos[pos] = i++;
            }
            this.setFieldTypes(types);
            this.targetPositions = new int[numConfigFields];
            int k = 0;
            for (i = 0; i < targetPos.length; ++i) {
                if (types[i] == null) continue;
                this.targetPositions[k++] = targetPos[i];
            }
        } else if (this.targetPositions.length == 0) {
            this.targetPositions = new int[this.getNumberOfNonNullFields()];
            for (int i = 0; i < this.targetPositions.length; ++i) {
                this.targetPositions[i] = i;
            }
        }
        if (this.getNumberOfNonNullFields() == 0) {
            throw new IllegalConfigurationException("No fields configured in the CsvInputFormat.");
        }
        this.configured = true;
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        this.parsedValues = new Value[fieldParsers.length];
        for (int i = 0; i < fieldParsers.length; ++i) {
            this.parsedValues[i] = (Value)fieldParsers[i].createValue();
        }
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10) {
            this.lineDelimiterIsLinebreak = true;
        }
    }

    public Record readRecord(Record reuse, byte[] bytes, int offset, int numBytes) throws ParseException {
        if (this.lineDelimiterIsLinebreak && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.parseRecord(this.parsedValues, bytes, offset, numBytes)) {
            for (int i = 0; i < this.parsedValues.length; ++i) {
                reuse.setField(this.targetPositions[i], this.parsedValues[i]);
            }
            return reuse;
        }
        return null;
    }

    public static ConfigBuilder configureRecordFormat(FileDataSource target) {
        return new ConfigBuilder((Operator<?>)target, target.getParameters());
    }

    private static final class RecordFormatCompilerHints
    extends CompilerHints {
        private float width = 0.0f;

        private RecordFormatCompilerHints(CompilerHints parent) {
            this.copyFrom(parent);
        }

        public float getAvgOutputRecordSize() {
            float superWidth = super.getAvgOutputRecordSize();
            if (superWidth > 0.0f || this.width <= 0.0f) {
                return superWidth;
            }
            return this.width;
        }

        private void addWidthRecordFormat(float width) {
            this.width += width;
        }
    }

    public static class ConfigBuilder
    extends AbstractConfigBuilder<ConfigBuilder> {
        protected ConfigBuilder(Operator<?> target, Configuration targetConfig) {
            super(target, targetConfig);
        }
    }

    protected static class AbstractConfigBuilder<T>
    extends DelimitedInputFormat.AbstractConfigBuilder<T> {
        protected final RecordFormatCompilerHints hints;

        protected AbstractConfigBuilder(Operator<?> contract, Configuration config) {
            super(config);
            if (contract != null) {
                this.hints = new RecordFormatCompilerHints(contract.getCompilerHints());
                this.hints.addWidthRecordFormat(2.0f);
            } else {
                this.hints = new RecordFormatCompilerHints(new CompilerHints());
            }
        }

        public T fieldDelimiter(char delimiter) {
            this.config.setString(CsvInputFormat.FIELD_DELIMITER_PARAMETER, String.valueOf(delimiter));
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T field(Class<? extends Value> type, int textPosition) {
            return this.field(type, textPosition, Float.NEGATIVE_INFINITY);
        }

        public T field(Class<? extends Value> type, int textPosition, float avgLen) {
            int numYet = this.config.getInteger(CsvInputFormat.NUM_FIELDS_PARAMETER, 0);
            this.config.setClass(CsvInputFormat.FIELD_TYPE_PARAMETER_PREFIX + numYet, type);
            this.config.setInteger(CsvInputFormat.TEXT_POSITION_PARAMETER_PREFIX + numYet, textPosition);
            this.config.setInteger(CsvInputFormat.NUM_FIELDS_PARAMETER, numYet + 1);
            if (avgLen == Float.NEGATIVE_INFINITY) {
                if (type == IntValue.class) {
                    avgLen = 4.0f;
                } else if (type == DoubleValue.class || type == LongValue.class) {
                    avgLen = 8.0f;
                }
            }
            if (avgLen != Float.NEGATIVE_INFINITY) {
                this.hints.addWidthRecordFormat(avgLen + 1.0f);
            }
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }
    }
}

