/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.java.record.io.FileOutputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Record;

public abstract class DelimitedOutputFormat
extends FileOutputFormat {
    private static final long serialVersionUID = 1L;
    public static final String RECORD_DELIMITER = "pact.output.delimited.delimiter";
    private static final String RECORD_DELIMITER_ENCODING = "pact.output.delimited.delimiter-encoding";
    public static final String WRITE_BUFFER_SIZE = "pact.output.delimited.buffersize";
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 65536;
    private static final int MIN_WRITE_BUFFER_SIZE = 1024;
    private byte[] delimiter;
    private byte[] buffer;
    private byte[] targetArray = new byte[64];
    private int pos;
    private int bufferSize;

    public void configure(Configuration config) {
        super.configure(config);
        String delim = config.getString(RECORD_DELIMITER, "\n");
        String charsetName = config.getString(RECORD_DELIMITER_ENCODING, null);
        if (delim == null) {
            throw new IllegalArgumentException("The delimiter in the DelimitedOutputFormat must not be null.");
        }
        try {
            this.delimiter = charsetName == null ? delim.getBytes() : delim.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException useex) {
            throw new IllegalArgumentException("The charset with the name '" + charsetName + "' is not supported on this TaskManager instance.", useex);
        }
        this.bufferSize = config.getInteger(WRITE_BUFFER_SIZE, 65536);
        if (this.bufferSize < 1024) {
            throw new IllegalArgumentException("The write buffer size must not be less than 1024 bytes.");
        }
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
        }
        if (this.targetArray == null) {
            this.targetArray = new byte[64];
        }
        this.pos = 0;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.write(this.buffer, 0, this.pos);
        }
        super.close();
    }

    public abstract int serializeRecord(Record var1, byte[] var2) throws Exception;

    public void writeRecord(Record record) throws IOException {
        int size;
        try {
            while ((size = this.serializeRecord(record, this.targetArray)) < 0) {
                if (-size > this.targetArray.length) {
                    this.targetArray = new byte[-size];
                    continue;
                }
                this.targetArray = new byte[this.targetArray.length * 2];
            }
        }
        catch (Exception ex) {
            throw new IOException("Error while serializing the record to bytes: " + ex.getMessage(), ex);
        }
        if (this.bufferSize - this.pos > size + this.delimiter.length) {
            System.arraycopy(this.targetArray, 0, this.buffer, this.pos, size);
            System.arraycopy(this.delimiter, 0, this.buffer, this.pos + size, this.delimiter.length);
            this.pos += size + this.delimiter.length;
        } else {
            int toCopy;
            int off = 0;
            while (off < size) {
                toCopy = Math.min(size - off, this.bufferSize - this.pos);
                System.arraycopy(this.targetArray, off, this.buffer, this.pos, toCopy);
                off += toCopy;
                this.pos += toCopy;
                if (this.pos != this.bufferSize) continue;
                this.pos = 0;
                this.stream.write(this.buffer, 0, this.bufferSize);
            }
            off = 0;
            while (off < this.delimiter.length) {
                toCopy = Math.min(this.delimiter.length - off, this.bufferSize - this.pos);
                System.arraycopy(this.delimiter, off, this.buffer, this.pos, toCopy);
                off += toCopy;
                this.pos += toCopy;
                if (this.pos != this.bufferSize) continue;
                this.pos = 0;
                this.stream.write(this.buffer, 0, this.bufferSize);
            }
        }
    }

    public static ConfigBuilder configureDelimitedFormat(FileDataSink target) {
        return new ConfigBuilder(target.getParameters());
    }

    public static class ConfigBuilder
    extends AbstractConfigBuilder<ConfigBuilder> {
        protected ConfigBuilder(Configuration targetConfig) {
            super(targetConfig);
        }
    }

    protected static abstract class AbstractConfigBuilder<T>
    extends FileOutputFormat.AbstractConfigBuilder<T> {
        private static final String NEWLINE_DELIMITER = "\n";

        protected AbstractConfigBuilder(Configuration config) {
            super(config);
        }

        public T recordDelimiter(char delimiter) {
            if (delimiter == '\n') {
                this.config.setString(DelimitedOutputFormat.RECORD_DELIMITER, NEWLINE_DELIMITER);
            } else {
                this.config.setString(DelimitedOutputFormat.RECORD_DELIMITER, String.valueOf(delimiter));
            }
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T recordDelimiter(String delimiter) {
            this.config.setString(DelimitedOutputFormat.RECORD_DELIMITER, delimiter);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T recordDelimiter(String delimiter, String charsetName) {
            this.config.setString(DelimitedOutputFormat.RECORD_DELIMITER, delimiter);
            this.config.setString(DelimitedOutputFormat.RECORD_DELIMITER_ENCODING, charsetName);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T writeBufferSize(int sizeInBytes) {
            this.config.setInteger(DelimitedOutputFormat.WRITE_BUFFER_SIZE, sizeInBytes);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }
    }
}

