/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.configuration.Configuration;

public class RemoteEnvironment
extends ExecutionEnvironment {
    protected final String host;
    protected final int port;
    private final URL[] jarFiles;
    private Configuration clientConfiguration;
    private PlanExecutor executor;
    private Thread shutdownHook;
    private final URL[] globalClasspaths;

    public RemoteEnvironment(String host, int port, String ... jarFiles) {
        this(host, port, (Configuration)null, jarFiles, (URL[])null);
    }

    public RemoteEnvironment(String host, int port, Configuration clientConfig, String[] jarFiles) {
        this(host, port, clientConfig, jarFiles, null);
    }

    public RemoteEnvironment(String host, int port, Configuration clientConfig, String[] jarFiles, URL[] globalClasspaths) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The RemoteEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        if (host == null) {
            throw new NullPointerException("Host must not be null.");
        }
        if (port < 1 || port >= 65535) {
            throw new IllegalArgumentException("Port out of range");
        }
        this.host = host;
        this.port = port;
        Configuration configuration = this.clientConfiguration = clientConfig == null ? new Configuration() : clientConfig;
        if (jarFiles != null) {
            this.jarFiles = new URL[jarFiles.length];
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    this.jarFiles[i] = new File(jarFiles[i]).getAbsoluteFile().toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("JAR file path invalid", e);
                }
            }
        } else {
            this.jarFiles = null;
        }
        this.globalClasspaths = globalClasspaths;
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JobExecutionResult result;
        this.ensureExecutorCreated();
        JavaPlan p = this.createProgramPlan(jobName);
        this.lastJobExecutionResult = result = this.executor.executePlan((Plan)p);
        return result;
    }

    @Override
    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan("plan", false);
        if (this.executor != null) {
            return this.executor.getOptimizerPlanAsJSON((Plan)p);
        }
        PlanExecutor le = PlanExecutor.createLocalExecutor(null);
        return le.getOptimizerPlanAsJSON((Plan)p);
    }

    @Override
    public void startNewSession() throws Exception {
        this.dispose();
        this.jobID = JobID.generate();
        this.installShutdownHook();
    }

    private void ensureExecutorCreated() throws Exception {
        if (this.executor == null) {
            this.executor = PlanExecutor.createRemoteExecutor((String)this.host, (int)this.port, (Configuration)this.clientConfiguration, (URL[])this.jarFiles, (URL[])this.globalClasspaths);
            this.executor.setPrintStatusDuringExecution(this.getConfig().isSysoutLoggingEnabled());
        }
        if (this.getSessionTimeout() > 0L && !this.executor.isRunning()) {
            this.executor.start();
            this.installShutdownHook();
        }
    }

    protected void dispose() {
        if (this.shutdownHook != null && this.shutdownHook != Thread.currentThread()) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable t) {
                LOG.warn("Exception while unregistering the cleanup shutdown hook.");
            }
        }
        try {
            PlanExecutor executor = this.executor;
            if (executor != null) {
                executor.endSession(this.jobID);
                executor.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dispose the session shutdown hook.");
        }
    }

    public String toString() {
        return "Remote Environment (" + this.host + ":" + this.port + " - parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    private void installShutdownHook() {
        if (this.shutdownHook == null) {
            Thread shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteEnvironment.this.dispose();
                    }
                    catch (Throwable t) {
                        ExecutionEnvironment.LOG.error("Error in cleanup of RemoteEnvironment during JVM shutdown: " + t.getMessage(), t);
                    }
                }
            });
            try {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                this.shutdownHook = shutdownHook;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable t) {
                LOG.error("Cannot register shutdown hook that cleanly terminates the BLOB service.");
            }
        }
    }
}

