/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.commons.lang3.ClassUtils;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.typeutils.AvroTypeInfo;
import org.apache.flink.api.java.typeutils.EnumTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeExtractor.class);

    protected TypeExtractor() {
    }

    public static <IN, OUT> TypeInformation<OUT> getMapReturnTypes(MapFunction<IN, OUT> mapInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getMapReturnTypes(mapInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getMapReturnTypes(MapFunction<IN, OUT> mapInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(mapInterface, MapFunction.class, false, false, inType, functionName, allowMissing);
    }

    public static <IN, OUT> TypeInformation<OUT> getFlatMapReturnTypes(FlatMapFunction<IN, OUT> flatMapInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getFlatMapReturnTypes(flatMapInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getFlatMapReturnTypes(FlatMapFunction<IN, OUT> flatMapInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(flatMapInterface, FlatMapFunction.class, false, true, inType, functionName, allowMissing);
    }

    public static <IN, OUT> TypeInformation<OUT> getFoldReturnTypes(FoldFunction<IN, OUT> foldInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getFoldReturnTypes(foldInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getFoldReturnTypes(FoldFunction<IN, OUT> foldInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(foldInterface, FoldFunction.class, false, false, inType, functionName, allowMissing);
    }

    public static <IN, OUT> TypeInformation<OUT> getMapPartitionReturnTypes(MapPartitionFunction<IN, OUT> mapPartitionInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getMapPartitionReturnTypes(mapPartitionInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getMapPartitionReturnTypes(MapPartitionFunction<IN, OUT> mapPartitionInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(mapPartitionInterface, MapPartitionFunction.class, true, true, inType, functionName, allowMissing);
    }

    public static <IN, OUT> TypeInformation<OUT> getGroupReduceReturnTypes(GroupReduceFunction<IN, OUT> groupReduceInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getGroupReduceReturnTypes(groupReduceInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getGroupReduceReturnTypes(GroupReduceFunction<IN, OUT> groupReduceInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(groupReduceInterface, GroupReduceFunction.class, true, true, inType, functionName, allowMissing);
    }

    public static <IN, OUT> TypeInformation<OUT> getGroupCombineReturnTypes(GroupCombineFunction<IN, OUT> combineInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getGroupCombineReturnTypes(combineInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getGroupCombineReturnTypes(GroupCombineFunction<IN, OUT> combineInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(combineInterface, GroupCombineFunction.class, true, true, inType, functionName, allowMissing);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getFlatJoinReturnTypes(FlatJoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getFlatJoinReturnTypes(joinInterface, in1Type, in2Type, null, false);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getFlatJoinReturnTypes(FlatJoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(joinInterface, FlatJoinFunction.class, false, true, in1Type, in2Type, functionName, allowMissing);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getJoinReturnTypes(JoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getJoinReturnTypes(joinInterface, in1Type, in2Type, null, false);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getJoinReturnTypes(JoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(joinInterface, JoinFunction.class, false, false, in1Type, in2Type, functionName, allowMissing);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getCoGroupReturnTypes(CoGroupFunction<IN1, IN2, OUT> coGroupInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getCoGroupReturnTypes(coGroupInterface, in1Type, in2Type, null, false);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getCoGroupReturnTypes(CoGroupFunction<IN1, IN2, OUT> coGroupInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(coGroupInterface, CoGroupFunction.class, true, true, in1Type, in2Type, functionName, allowMissing);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getCrossReturnTypes(CrossFunction<IN1, IN2, OUT> crossInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getCrossReturnTypes(crossInterface, in1Type, in2Type, null, false);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getCrossReturnTypes(CrossFunction<IN1, IN2, OUT> crossInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(crossInterface, CrossFunction.class, false, false, in1Type, in2Type, functionName, allowMissing);
    }

    public static <IN, OUT> TypeInformation<OUT> getKeySelectorTypes(KeySelector<IN, OUT> selectorInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getKeySelectorTypes(selectorInterface, inType, null, false);
    }

    public static <IN, OUT> TypeInformation<OUT> getKeySelectorTypes(KeySelector<IN, OUT> selectorInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(selectorInterface, KeySelector.class, false, false, inType, functionName, allowMissing);
    }

    public static <T> TypeInformation<T> getPartitionerTypes(Partitioner<T> partitioner) {
        return TypeExtractor.getPartitionerTypes(partitioner, null, false);
    }

    public static <T> TypeInformation<T> getPartitionerTypes(Partitioner<T> partitioner, String functionName, boolean allowMissing) {
        return new TypeExtractor().privateCreateTypeInfo(Partitioner.class, partitioner.getClass(), 0, null, null);
    }

    public static <IN> TypeInformation<IN> getInputFormatTypes(InputFormat<IN, ?> inputFormatInterface) {
        if (inputFormatInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)inputFormatInterface).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(InputFormat.class, inputFormatInterface.getClass(), 0, null, null);
    }

    public static <IN, OUT> TypeInformation<OUT> getUnaryOperatorReturnType(Function function, Class<?> baseClass, boolean hasIterable, boolean hasCollector, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        try {
            Method m = FunctionUtils.checkAndExtractLambdaMethod((Function)function);
            if (m != null) {
                TypeExtractor.validateLambdaGenericParameters(m);
                int paramLen = m.getGenericParameterTypes().length - 1;
                Type input = hasCollector ? m.getGenericParameterTypes()[paramLen - 1] : m.getGenericParameterTypes()[paramLen];
                TypeExtractor.validateInputType(hasIterable ? TypeExtractor.removeGenericWrapper(input) : input, inType);
                if (function instanceof ResultTypeQueryable) {
                    return ((ResultTypeQueryable)function).getProducedType();
                }
                return new TypeExtractor().privateCreateTypeInfo(hasCollector ? TypeExtractor.removeGenericWrapper(m.getGenericParameterTypes()[paramLen]) : m.getGenericReturnType(), inType, null);
            }
            TypeExtractor.validateInputType(baseClass, function.getClass(), 0, inType);
            if (function instanceof ResultTypeQueryable) {
                return ((ResultTypeQueryable)function).getProducedType();
            }
            return new TypeExtractor().privateCreateTypeInfo(baseClass, function.getClass(), 1, inType, null);
        }
        catch (InvalidTypesException e) {
            if (allowMissing) {
                return new MissingTypeInfo(functionName != null ? functionName : function.toString(), e);
            }
            throw e;
        }
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getBinaryOperatorReturnType(Function function, Class<?> baseClass, boolean hasIterables, boolean hasCollector, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        try {
            Method m = FunctionUtils.checkAndExtractLambdaMethod((Function)function);
            if (m != null) {
                TypeExtractor.validateLambdaGenericParameters(m);
                int paramLen = m.getGenericParameterTypes().length - 1;
                Type input1 = hasCollector ? m.getGenericParameterTypes()[paramLen - 2] : m.getGenericParameterTypes()[paramLen - 1];
                Type input2 = hasCollector ? m.getGenericParameterTypes()[paramLen - 1] : m.getGenericParameterTypes()[paramLen];
                TypeExtractor.validateInputType(hasIterables ? TypeExtractor.removeGenericWrapper(input1) : input1, in1Type);
                TypeExtractor.validateInputType(hasIterables ? TypeExtractor.removeGenericWrapper(input2) : input2, in2Type);
                if (function instanceof ResultTypeQueryable) {
                    return ((ResultTypeQueryable)function).getProducedType();
                }
                return new TypeExtractor().privateCreateTypeInfo(hasCollector ? TypeExtractor.removeGenericWrapper(m.getGenericParameterTypes()[paramLen]) : m.getGenericReturnType(), in1Type, in2Type);
            }
            TypeExtractor.validateInputType(baseClass, function.getClass(), 0, in1Type);
            TypeExtractor.validateInputType(baseClass, function.getClass(), 1, in2Type);
            if (function instanceof ResultTypeQueryable) {
                return ((ResultTypeQueryable)function).getProducedType();
            }
            return new TypeExtractor().privateCreateTypeInfo(baseClass, function.getClass(), 2, in1Type, in2Type);
        }
        catch (InvalidTypesException e) {
            if (allowMissing) {
                return new MissingTypeInfo(functionName != null ? functionName : function.toString(), e);
            }
            throw e;
        }
    }

    public static TypeInformation<?> createTypeInfo(Type t) {
        TypeInformation<?> ti = new TypeExtractor().privateCreateTypeInfo(t);
        if (ti == null) {
            throw new InvalidTypesException("Could not extract type information.");
        }
        return ti;
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfo(Class<?> baseClass, Class<?> clazz, int returnParamPos, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeInformation<OUT> ti = new TypeExtractor().privateCreateTypeInfo(baseClass, clazz, returnParamPos, in1Type, in2Type);
        if (ti == null) {
            throw new InvalidTypesException("Could not extract type information.");
        }
        return ti;
    }

    private TypeInformation<?> privateCreateTypeInfo(Type t) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(t);
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, t, null, null);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> privateCreateTypeInfo(Class<?> baseClass, Class<?> clazz, int returnParamPos, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeInformation<?> typeInfo;
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        Type returnType = TypeExtractor.getParameterType(baseClass, typeHierarchy, clazz, returnParamPos);
        if (returnType instanceof TypeVariable && (typeInfo = this.createTypeInfoFromInputs((TypeVariable)returnType, typeHierarchy, in1Type, in2Type)) != null) {
            return typeInfo;
        }
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, returnType, in1Type, in2Type);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> privateCreateTypeInfo(Type returnType, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, returnType, in1Type, in2Type);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfoWithTypeHierarchy(ArrayList<Type> typeHierarchy, Type t, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        if (TypeExtractor.isClassType(t) && Tuple.class.isAssignableFrom(TypeExtractor.typeToClass(t))) {
            Type curT = t;
            if (TypeExtractor.typeToClass(t).equals(Tuple.class)) {
                throw new InvalidTypesException("Usage of class Tuple as a type is not allowed. Use a concrete subclass (e.g. Tuple1, Tuple2, etc.) instead.");
            }
            while (!TypeExtractor.isClassType(curT) || !TypeExtractor.typeToClass(curT).getSuperclass().equals(Tuple.class)) {
                typeHierarchy.add(curT);
                curT = TypeExtractor.typeToClass(curT).getGenericSuperclass();
            }
            if (curT == Tuple0.class) {
                return new TupleTypeInfo<Tuple0>(Tuple0.class, new TypeInformation[0]);
            }
            if (curT instanceof Class) {
                throw new InvalidTypesException("Tuple needs to be parameterized by using generics.");
            }
            typeHierarchy.add(curT);
            ParameterizedType tupleChild = (ParameterizedType)curT;
            Type[] subtypes = new Type[tupleChild.getActualTypeArguments().length];
            for (int i = 0; i < subtypes.length; ++i) {
                subtypes[i] = tupleChild.getActualTypeArguments()[i] instanceof TypeVariable ? TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)tupleChild.getActualTypeArguments()[i]) : tupleChild.getActualTypeArguments()[i];
            }
            TypeInformation[] tupleSubTypes = new TypeInformation[subtypes.length];
            for (int i = 0; i < subtypes.length; ++i) {
                ArrayList<Type> subTypeHierarchy = new ArrayList<Type>(typeHierarchy);
                subTypeHierarchy.add(subtypes[i]);
                if (subtypes[i] instanceof TypeVariable) {
                    tupleSubTypes[i] = this.createTypeInfoFromInputs((TypeVariable)subtypes[i], subTypeHierarchy, in1Type, in2Type);
                    if (tupleSubTypes[i] != null) continue;
                    throw new InvalidTypesException("Type of TypeVariable '" + ((TypeVariable)subtypes[i]).getName() + "' in '" + ((TypeVariable)subtypes[i]).getGenericDeclaration() + "' could not be determined. This is most likely a type erasure problem. " + "The type extraction currently supports types with generic variables only in cases where " + "all variables in the return type can be deduced from the input type(s).");
                }
                tupleSubTypes[i] = this.createTypeInfoWithTypeHierarchy(subTypeHierarchy, subtypes[i], in1Type, in2Type);
            }
            Class<?> tAsClass = null;
            if (TypeExtractor.isClassType(t)) {
                tAsClass = TypeExtractor.typeToClass(t);
            }
            Preconditions.checkNotNull(tAsClass, "t has a unexpected type");
            int fieldCount = this.countFieldsInClass(tAsClass);
            if (fieldCount != tupleSubTypes.length) {
                if (t instanceof ParameterizedType) {
                    return this.analyzePojo(tAsClass, new ArrayList<Type>(typeHierarchy), (ParameterizedType)t, in1Type, in2Type);
                }
                return this.analyzePojo(tAsClass, new ArrayList<Type>(typeHierarchy), null, in1Type, in2Type);
            }
            return new TupleTypeInfo(tAsClass, tupleSubTypes);
        }
        if (t instanceof TypeVariable) {
            Type typeVar = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)t);
            if (!(typeVar instanceof TypeVariable)) {
                return this.createTypeInfoWithTypeHierarchy(typeHierarchy, typeVar, in1Type, in2Type);
            }
            TypeInformation<?> typeInfo = this.createTypeInfoFromInputs((TypeVariable)t, typeHierarchy, in1Type, in2Type);
            if (typeInfo != null) {
                return typeInfo;
            }
            throw new InvalidTypesException("Type of TypeVariable '" + ((TypeVariable)t).getName() + "' in '" + ((TypeVariable)t).getGenericDeclaration() + "' could not be determined. This is most likely a type erasure problem. " + "The type extraction currently supports types with generic variables only in cases where " + "all variables in the return type can be deduced from the input type(s).");
        }
        if (t instanceof GenericArrayType) {
            Class<?> classArray;
            GenericArrayType genericArray = (GenericArrayType)t;
            Type componentType = genericArray.getGenericComponentType();
            if (componentType instanceof Class) {
                Class<?> classArray2;
                Class componentClass = (Class)componentType;
                String className = componentClass.isPrimitive() ? TypeExtractor.encodePrimitiveClass(componentClass) : "L" + componentClass.getName() + ";";
                try {
                    classArray2 = Class.forName("[" + className);
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidTypesException("Could not convert GenericArrayType to Class.");
                }
                return TypeExtractor.getForClass(classArray2);
            }
            TypeInformation<OUT> componentInfo = this.createTypeInfoWithTypeHierarchy(typeHierarchy, genericArray.getGenericComponentType(), in1Type, in2Type);
            try {
                String componentClassName = componentInfo.getTypeClass().getName();
                String resultingClassName = componentClassName.startsWith("[") ? "[" + componentClassName : "[L" + componentClassName + ";";
                classArray = Class.forName(resultingClassName);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidTypesException("Could not convert GenericArrayType to Class.");
            }
            return ObjectArrayTypeInfo.getInfoFor(classArray, componentInfo);
        }
        if (t instanceof ParameterizedType) {
            return this.privateGetForClass(TypeExtractor.typeToClass(t), typeHierarchy, (ParameterizedType)t, in1Type, in2Type);
        }
        if (t instanceof Class) {
            return this.privateGetForClass((Class)t, typeHierarchy);
        }
        throw new InvalidTypesException("Type Information could not be created.");
    }

    private <IN1, IN2> TypeInformation<?> createTypeInfoFromInputs(TypeVariable<?> returnTypeVar, ArrayList<Type> returnTypeHierarchy, TypeInformation<IN1> in1TypeInfo, TypeInformation<IN2> in2TypeInfo) {
        Type matReturnTypeVar = TypeExtractor.materializeTypeVariable(returnTypeHierarchy, returnTypeVar);
        if (!(matReturnTypeVar instanceof TypeVariable)) {
            return this.createTypeInfoWithTypeHierarchy(returnTypeHierarchy, matReturnTypeVar, in1TypeInfo, in2TypeInfo);
        }
        returnTypeVar = (TypeVariable)matReturnTypeVar;
        if (in1TypeInfo == null && in2TypeInfo == null) {
            return null;
        }
        ArrayList<Type> inputTypeHierarchy = new ArrayList<Type>();
        for (Type t : returnTypeHierarchy) {
            if (!TypeExtractor.isClassType(t) || !Function.class.isAssignableFrom(TypeExtractor.typeToClass(t)) || TypeExtractor.typeToClass(t) == Function.class) break;
            inputTypeHierarchy.add(t);
        }
        ParameterizedType baseClass = (ParameterizedType)inputTypeHierarchy.get(inputTypeHierarchy.size() - 1);
        TypeInformation<?> info = null;
        if (in1TypeInfo != null) {
            Type in1Type = baseClass.getActualTypeArguments()[0];
            info = this.createTypeInfoFromInput(returnTypeVar, new ArrayList<Type>(inputTypeHierarchy), in1Type, in1TypeInfo);
        }
        if (info == null && in2TypeInfo != null) {
            Type in2Type = baseClass.getActualTypeArguments()[1];
            info = this.createTypeInfoFromInput(returnTypeVar, new ArrayList<Type>(inputTypeHierarchy), in2Type, in2TypeInfo);
        }
        if (info != null) {
            return info;
        }
        return null;
    }

    private <IN1> TypeInformation<?> createTypeInfoFromInput(TypeVariable<?> returnTypeVar, ArrayList<Type> inputTypeHierarchy, Type inType, TypeInformation<IN1> inTypeInfo) {
        TypeInformation<?> info = null;
        if (inType instanceof TypeVariable) {
            inType = TypeExtractor.materializeTypeVariable(inputTypeHierarchy, (TypeVariable)inType);
            info = TypeExtractor.findCorrespondingInfo(returnTypeVar, inType, inTypeInfo, inputTypeHierarchy);
        } else if (inType instanceof GenericArrayType) {
            TypeInformation componentInfo = null;
            if (inTypeInfo instanceof BasicArrayTypeInfo) {
                componentInfo = ((BasicArrayTypeInfo)inTypeInfo).getComponentInfo();
            } else if (inTypeInfo instanceof PrimitiveArrayTypeInfo) {
                componentInfo = BasicTypeInfo.getInfoFor(inTypeInfo.getTypeClass().getComponentType());
            } else if (inTypeInfo instanceof ObjectArrayTypeInfo) {
                componentInfo = ((ObjectArrayTypeInfo)inTypeInfo).getComponentInfo();
            }
            info = this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, ((GenericArrayType)inType).getGenericComponentType(), componentInfo);
        } else if (inTypeInfo instanceof TupleTypeInfo && TypeExtractor.isClassType(inType) && Tuple.class.isAssignableFrom(TypeExtractor.typeToClass(inType))) {
            while (!TypeExtractor.isClassType(inType) || !TypeExtractor.typeToClass(inType).getSuperclass().equals(Tuple.class)) {
                inputTypeHierarchy.add(inType);
                inType = TypeExtractor.typeToClass(inType).getGenericSuperclass();
            }
            inputTypeHierarchy.add(inType);
            ParameterizedType tupleBaseClass = (ParameterizedType)inType;
            Type[] tupleElements = tupleBaseClass.getActualTypeArguments();
            for (int i = 0; i < tupleElements.length && (info = this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, tupleElements[i], ((TupleTypeInfo)inTypeInfo).getTypeAt(i))) == null; ++i) {
            }
        } else if (inTypeInfo instanceof PojoTypeInfo) {
            TypeExtractor.getTypeHierarchy(inputTypeHierarchy, inType, Object.class);
            info = TypeExtractor.findCorrespondingInfo(returnTypeVar, inType, inTypeInfo, inputTypeHierarchy);
        }
        return info;
    }

    public static Type getParameterType(Class<?> baseClass, Class<?> clazz, int pos) {
        return TypeExtractor.getParameterType(baseClass, null, clazz, pos);
    }

    private static Type getParameterType(Class<?> baseClass, ArrayList<Type> typeHierarchy, Class<?> clazz, int pos) {
        Type[] interfaceTypes;
        if (typeHierarchy != null) {
            typeHierarchy.add(clazz);
        }
        for (Type t : interfaceTypes = clazz.getGenericInterfaces()) {
            Type parameter = TypeExtractor.getParameterTypeFromGenericType(baseClass, typeHierarchy, t, pos);
            if (parameter == null) continue;
            return parameter;
        }
        Type t = clazz.getGenericSuperclass();
        Type parameter = TypeExtractor.getParameterTypeFromGenericType(baseClass, typeHierarchy, t, pos);
        if (parameter != null) {
            return parameter;
        }
        throw new InvalidTypesException("The types of the interface " + baseClass.getName() + " could not be inferred. " + "Support for synthetic interfaces, lambdas, and generic or raw types is limited at this point");
    }

    private static Type getParameterTypeFromGenericType(Class<?> baseClass, ArrayList<Type> typeHierarchy, Type t, int pos) {
        if (t instanceof ParameterizedType && baseClass.equals(((ParameterizedType)t).getRawType())) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            ParameterizedType baseClassChild = (ParameterizedType)t;
            return baseClassChild.getActualTypeArguments()[pos];
        }
        if (t instanceof ParameterizedType && baseClass.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            return TypeExtractor.getParameterType(baseClass, typeHierarchy, (Class)((ParameterizedType)t).getRawType(), pos);
        }
        if (t instanceof Class && baseClass.isAssignableFrom((Class)t)) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            return TypeExtractor.getParameterType(baseClass, typeHierarchy, (Class)t, pos);
        }
        return null;
    }

    private static void validateInputType(Type t, TypeInformation<?> inType) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        try {
            TypeExtractor.validateInfo(typeHierarchy, t, inType);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Input mismatch: " + e.getMessage());
        }
    }

    private static void validateInputType(Class<?> baseClass, Class<?> clazz, int inputParamPos, TypeInformation<?> inTypeInfo) {
        Type inType;
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        try {
            inType = TypeExtractor.getParameterType(baseClass, typeHierarchy, clazz, inputParamPos);
        }
        catch (InvalidTypesException e) {
            return;
        }
        try {
            TypeExtractor.validateInfo(typeHierarchy, inType, inTypeInfo);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Input mismatch: " + e.getMessage());
        }
    }

    private static void validateInfo(ArrayList<Type> typeHierarchy, Type type, TypeInformation<?> typeInfo) {
        block33: {
            block31: {
                Class<?> clazz;
                block43: {
                    block42: {
                        block40: {
                            Class<?> clazz2;
                            block41: {
                                block39: {
                                    block38: {
                                        block37: {
                                            Type component;
                                            block36: {
                                                Type component2;
                                                block35: {
                                                    block34: {
                                                        block32: {
                                                            BasicTypeInfo actual;
                                                            if (type == null) {
                                                                throw new InvalidTypesException("Unknown Error. Type is null.");
                                                            }
                                                            if (typeInfo == null) {
                                                                throw new InvalidTypesException("Unknown Error. TypeInformation is null.");
                                                            }
                                                            if (type instanceof TypeVariable) break block31;
                                                            if (!typeInfo.isBasicType()) break block32;
                                                            if (!(type instanceof Class) || (actual = BasicTypeInfo.getInfoFor((Class)((Class)type))) == null) {
                                                                throw new InvalidTypesException("Basic type expected.");
                                                            }
                                                            if (!typeInfo.equals((Object)actual)) {
                                                                throw new InvalidTypesException("Basic type '" + typeInfo + "' expected but was '" + actual + "'.");
                                                            }
                                                            break block33;
                                                        }
                                                        if (!typeInfo.isTupleType()) break block34;
                                                        if (!TypeExtractor.isClassType(type) || !Tuple.class.isAssignableFrom(TypeExtractor.typeToClass(type))) {
                                                            throw new InvalidTypesException("Tuple type expected.");
                                                        }
                                                        if (TypeExtractor.isClassType(type) && TypeExtractor.typeToClass(type).equals(Tuple.class)) {
                                                            throw new InvalidTypesException("Concrete subclass of Tuple expected.");
                                                        }
                                                        while (!TypeExtractor.isClassType(type) || !TypeExtractor.typeToClass(type).getSuperclass().equals(Tuple.class)) {
                                                            typeHierarchy.add(type);
                                                            type = TypeExtractor.typeToClass(type).getGenericSuperclass();
                                                        }
                                                        if (type == Tuple0.class) {
                                                            return;
                                                        }
                                                        if (type instanceof Class) {
                                                            throw new InvalidTypesException("Parameterized Tuple type expected.");
                                                        }
                                                        TupleTypeInfo tti = (TupleTypeInfo)typeInfo;
                                                        Type[] subTypes = ((ParameterizedType)type).getActualTypeArguments();
                                                        if (subTypes.length != tti.getArity()) {
                                                            throw new InvalidTypesException("Tuple arity '" + tti.getArity() + "' expected but was '" + subTypes.length + "'.");
                                                        }
                                                        for (int i = 0; i < subTypes.length; ++i) {
                                                            TypeExtractor.validateInfo(new ArrayList<Type>(typeHierarchy), subTypes[i], ((TupleTypeInfo)typeInfo).getTypeAt(i));
                                                        }
                                                        break block33;
                                                    }
                                                    if (!(typeInfo instanceof WritableTypeInfo)) break block35;
                                                    if (!(type instanceof Class) || !Writable.class.isAssignableFrom((Class)type)) {
                                                        throw new InvalidTypesException("Writable type expected.");
                                                    }
                                                    Class clazz3 = (Class)type;
                                                    if (((WritableTypeInfo)typeInfo).getTypeClass() != clazz3) {
                                                        throw new InvalidTypesException("Writable type '" + ((WritableTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz3.getCanonicalName() + "'.");
                                                    }
                                                    break block33;
                                                }
                                                if (!(typeInfo instanceof PrimitiveArrayTypeInfo)) break block36;
                                                if (!(type instanceof Class && ((Class)type).isArray() && (component2 = ((Class)type).getComponentType()) != null || type instanceof GenericArrayType && (component2 = ((GenericArrayType)type).getGenericComponentType()) != null)) {
                                                    throw new InvalidTypesException("Array type expected.");
                                                }
                                                if (component2 instanceof TypeVariable && (component2 = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component2)) instanceof TypeVariable) {
                                                    return;
                                                }
                                                if (!(component2 instanceof Class) || !component2.isPrimitive()) {
                                                    throw new InvalidTypesException("Primitive component expected.");
                                                }
                                                break block33;
                                            }
                                            if (!(typeInfo instanceof BasicArrayTypeInfo)) break block37;
                                            if (!(type instanceof Class && ((Class)type).isArray() && (component = ((Class)type).getComponentType()) != null || type instanceof GenericArrayType && (component = ((GenericArrayType)type).getGenericComponentType()) != null)) {
                                                throw new InvalidTypesException("Array type expected.");
                                            }
                                            if (component instanceof TypeVariable && (component = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component)) instanceof TypeVariable) {
                                                return;
                                            }
                                            TypeExtractor.validateInfo(typeHierarchy, component, ((BasicArrayTypeInfo)typeInfo).getComponentInfo());
                                            break block33;
                                        }
                                        if (!(typeInfo instanceof ObjectArrayTypeInfo)) break block38;
                                        if (!(type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType)) {
                                            throw new InvalidTypesException("Object array type expected.");
                                        }
                                        Type component = type instanceof Class ? ((Class)type).getComponentType() : ((GenericArrayType)type).getGenericComponentType();
                                        if (component instanceof TypeVariable && (component = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component)) instanceof TypeVariable) {
                                            return;
                                        }
                                        TypeExtractor.validateInfo(typeHierarchy, component, ((ObjectArrayTypeInfo)typeInfo).getComponentInfo());
                                        break block33;
                                    }
                                    if (!(typeInfo instanceof ValueTypeInfo)) break block39;
                                    if (!(type instanceof Class) || !Value.class.isAssignableFrom((Class)type)) {
                                        throw new InvalidTypesException("Value type expected.");
                                    }
                                    TypeInformation actual = ValueTypeInfo.getValueTypeInfo((Class)type);
                                    if (!((ValueTypeInfo)typeInfo).equals(actual)) {
                                        throw new InvalidTypesException("Value type '" + typeInfo + "' expected but was '" + actual + "'.");
                                    }
                                    break block33;
                                }
                                if (!(typeInfo instanceof PojoTypeInfo)) break block40;
                                clazz2 = null;
                                if (!TypeExtractor.isClassType(type)) break block41;
                                clazz2 = TypeExtractor.typeToClass(type);
                                if (((PojoTypeInfo)typeInfo).getTypeClass() == clazz2) break block33;
                            }
                            throw new InvalidTypesException("POJO type '" + ((PojoTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz2.getCanonicalName() + "'.");
                        }
                        if (!(typeInfo instanceof EnumTypeInfo)) break block42;
                        if (!(type instanceof Class) || !Enum.class.isAssignableFrom((Class)type)) {
                            throw new InvalidTypesException("Enum type expected.");
                        }
                        if (typeInfo.getTypeClass() != type) {
                            throw new InvalidTypesException("Enum type '" + typeInfo.getTypeClass().getCanonicalName() + "' expected but was '" + TypeExtractor.typeToClass(type).getCanonicalName() + "'.");
                        }
                        break block33;
                    }
                    if (!(typeInfo instanceof GenericTypeInfo)) break block33;
                    clazz = null;
                    if (!TypeExtractor.isClassType(type)) break block43;
                    clazz = TypeExtractor.typeToClass(type);
                    if (((GenericTypeInfo)typeInfo).getTypeClass() == clazz) break block33;
                }
                throw new InvalidTypesException("Generic object type '" + ((GenericTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz.getCanonicalName() + "'.");
            }
            if (!((type = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)type)) instanceof TypeVariable)) {
                TypeExtractor.validateInfo(typeHierarchy, type, typeInfo);
            }
        }
    }

    private static int countTypeInHierarchy(ArrayList<Type> typeHierarchy, Type type) {
        int count = 0;
        for (Type t : typeHierarchy) {
            if (t != type && (!TypeExtractor.isClassType(type) || t != TypeExtractor.typeToClass(type))) continue;
            ++count;
        }
        return count;
    }

    private static Type getTypeHierarchy(ArrayList<Type> typeHierarchy, Type curT, Class<?> stopAtClass) {
        if (typeHierarchy.size() > 0 && typeHierarchy.get(0) == curT && TypeExtractor.isClassType(curT)) {
            curT = TypeExtractor.typeToClass(curT).getGenericSuperclass();
        }
        while (!TypeExtractor.isClassType(curT) || !TypeExtractor.typeToClass(curT).equals(stopAtClass)) {
            typeHierarchy.add(curT);
            if ((curT = TypeExtractor.typeToClass(curT).getGenericSuperclass()) != null) continue;
            break;
        }
        return curT;
    }

    private int countFieldsInClass(Class<?> clazz) {
        int fieldCount = 0;
        for (Field field : clazz.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            ++fieldCount;
        }
        return fieldCount;
    }

    private static Type removeGenericWrapper(Type t) {
        if (t instanceof ParameterizedType && (Collector.class.isAssignableFrom(TypeExtractor.typeToClass(t)) || Iterable.class.isAssignableFrom(TypeExtractor.typeToClass(t)))) {
            return ((ParameterizedType)t).getActualTypeArguments()[0];
        }
        return t;
    }

    private static void validateLambdaGenericParameters(Method m) {
        for (Type t : m.getGenericParameterTypes()) {
            TypeExtractor.validateLambdaGenericParameter(t);
        }
        TypeExtractor.validateLambdaGenericParameter(m.getGenericReturnType());
    }

    private static void validateLambdaGenericParameter(Type t) {
        if (!(t instanceof Class)) {
            return;
        }
        Class clazz = (Class)t;
        if (clazz.getTypeParameters().length > 0) {
            throw new InvalidTypesException("The generic type parameters of '" + clazz.getSimpleName() + "' are missing. \n" + "It seems that your compiler has not stored them into the .class file. \n" + "Currently, only the Eclipse JDT compiler preserves the type information necessary to use the lambdas feature type-safely. \n" + "See the documentation for more information about how to compile jobs containing lambda expressions.");
        }
    }

    private static String encodePrimitiveClass(Class<?> primitiveClass) {
        if (primitiveClass == Boolean.TYPE) {
            return "Z";
        }
        if (primitiveClass == Byte.TYPE) {
            return "B";
        }
        if (primitiveClass == Character.TYPE) {
            return "C";
        }
        if (primitiveClass == Double.TYPE) {
            return "D";
        }
        if (primitiveClass == Float.TYPE) {
            return "F";
        }
        if (primitiveClass == Integer.TYPE) {
            return "I";
        }
        if (primitiveClass == Long.TYPE) {
            return "J";
        }
        if (primitiveClass == Short.TYPE) {
            return "S";
        }
        throw new InvalidTypesException();
    }

    private static TypeInformation<?> findCorrespondingInfo(TypeVariable<?> typeVar, Type type, TypeInformation<?> corrInfo, ArrayList<Type> typeHierarchy) {
        block12: {
            block13: {
                block11: {
                    if (TypeExtractor.sameTypeVars(type, typeVar)) {
                        return corrInfo;
                    }
                    if (type instanceof TypeVariable && TypeExtractor.sameTypeVars(TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)type), typeVar)) {
                        return corrInfo;
                    }
                    if (!(type instanceof GenericArrayType)) break block11;
                    TypeInformation componentInfo = null;
                    if (corrInfo instanceof BasicArrayTypeInfo) {
                        componentInfo = ((BasicArrayTypeInfo)corrInfo).getComponentInfo();
                    } else if (corrInfo instanceof PrimitiveArrayTypeInfo) {
                        componentInfo = BasicTypeInfo.getInfoFor(corrInfo.getTypeClass().getComponentType());
                    } else if (corrInfo instanceof ObjectArrayTypeInfo) {
                        componentInfo = ((ObjectArrayTypeInfo)corrInfo).getComponentInfo();
                    }
                    TypeInformation<?> info = TypeExtractor.findCorrespondingInfo(typeVar, ((GenericArrayType)type).getGenericComponentType(), componentInfo, typeHierarchy);
                    if (info != null) {
                        return info;
                    }
                    break block12;
                }
                if (!(corrInfo instanceof TupleTypeInfo) || !(type instanceof ParameterizedType) || !Tuple.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) break block13;
                ParameterizedType tuple = (ParameterizedType)type;
                Type[] args = tuple.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    TypeInformation<?> info = TypeExtractor.findCorrespondingInfo(typeVar, args[i], ((TupleTypeInfo)corrInfo).getTypeAt(i), typeHierarchy);
                    if (info == null) continue;
                    return info;
                }
                break block12;
            }
            if (!(corrInfo instanceof PojoTypeInfo) || !TypeExtractor.isClassType(type)) break block12;
            List<Field> fields = TypeExtractor.getAllDeclaredFields(TypeExtractor.typeToClass(type));
            for (Field field : fields) {
                Type fieldType = field.getGenericType();
                if (fieldType instanceof TypeVariable && TypeExtractor.sameTypeVars(typeVar, TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)fieldType))) {
                    return TypeExtractor.getTypeOfPojoField(corrInfo, field);
                }
                if (!(fieldType instanceof ParameterizedType) && !(fieldType instanceof GenericArrayType)) continue;
                ArrayList<Type> typeHierarchyWithFieldType = new ArrayList<Type>(typeHierarchy);
                typeHierarchyWithFieldType.add(fieldType);
                TypeInformation<?> info = TypeExtractor.findCorrespondingInfo(typeVar, fieldType, TypeExtractor.getTypeOfPojoField(corrInfo, field), typeHierarchyWithFieldType);
                if (info == null) continue;
                return info;
            }
        }
        return null;
    }

    private static Type materializeTypeVariable(ArrayList<Type> typeHierarchy, TypeVariable<?> typeVar) {
        TypeVariable inTypeTypeVar = typeVar;
        for (int i = typeHierarchy.size() - 1; i >= 0; --i) {
            Type curT = typeHierarchy.get(i);
            if (!(curT instanceof ParameterizedType)) continue;
            Class rawType = (Class)((ParameterizedType)curT).getRawType();
            for (int paramIndex = 0; paramIndex < rawType.getTypeParameters().length; ++paramIndex) {
                TypeVariable curVarOfCurT = rawType.getTypeParameters()[paramIndex];
                if (!TypeExtractor.sameTypeVars(curVarOfCurT, inTypeTypeVar)) continue;
                Type curVarType = ((ParameterizedType)curT).getActualTypeArguments()[paramIndex];
                if (curVarType instanceof TypeVariable) {
                    inTypeTypeVar = (TypeVariable)curVarType;
                    continue;
                }
                return curVarType;
            }
        }
        return inTypeTypeVar;
    }

    public static <X> TypeInformation<X> getForClass(Class<X> clazz) {
        return new TypeExtractor().privateGetForClass(clazz, new ArrayList<Type>());
    }

    private <X> TypeInformation<X> privateGetForClass(Class<X> clazz, ArrayList<Type> typeHierarchy) {
        return this.privateGetForClass(clazz, typeHierarchy, null, null, null);
    }

    private <OUT, IN1, IN2> TypeInformation<OUT> privateGetForClass(Class<OUT> clazz, ArrayList<Type> typeHierarchy, ParameterizedType parameterizedType, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        block17: {
            Preconditions.checkNotNull(clazz);
            if (clazz.equals(Object.class)) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            if (clazz.isArray()) {
                PrimitiveArrayTypeInfo primitiveArrayInfo = PrimitiveArrayTypeInfo.getInfoFor(clazz);
                if (primitiveArrayInfo != null) {
                    return primitiveArrayInfo;
                }
                BasicArrayTypeInfo basicArrayInfo = BasicArrayTypeInfo.getInfoFor(clazz);
                if (basicArrayInfo != null) {
                    return basicArrayInfo;
                }
                TypeInformation<OUT> componentTypeInfo = this.createTypeInfoWithTypeHierarchy(typeHierarchy, clazz.getComponentType(), in1Type, in2Type);
                return ObjectArrayTypeInfo.getInfoFor(clazz, componentTypeInfo);
            }
            if (Writable.class.isAssignableFrom(clazz) && !Writable.class.equals(clazz)) {
                return WritableTypeInfo.getWritableTypeInfo(clazz);
            }
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.getInfoFor(clazz);
            if (basicTypeInfo != null) {
                return basicTypeInfo;
            }
            if (Value.class.isAssignableFrom(clazz)) {
                Class<Value> valueClass = clazz.asSubclass(Value.class);
                return ValueTypeInfo.getValueTypeInfo(valueClass);
            }
            if (Tuple.class.isAssignableFrom(clazz)) {
                if (clazz == Tuple0.class) {
                    return new TupleTypeInfo<Tuple0>(Tuple0.class, new TypeInformation[0]);
                }
                throw new InvalidTypesException("Type information extraction for tuples (except Tuple0) cannot be done based on the class.");
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return new EnumTypeInfo<OUT>(clazz);
            }
            if (SpecificRecordBase.class.isAssignableFrom(clazz)) {
                return new AvroTypeInfo<OUT>(clazz);
            }
            if (TypeExtractor.countTypeInHierarchy(typeHierarchy, clazz) > 1) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            if (Modifier.isInterface(clazz.getModifiers())) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            if (clazz.equals(Class.class)) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            try {
                TypeInformation<OUT> pojoType = this.analyzePojo(clazz, new ArrayList<Type>(typeHierarchy), parameterizedType, in1Type, in2Type);
                if (pojoType != null) {
                    return pojoType;
                }
            }
            catch (InvalidTypesException e) {
                if (!LOG.isDebugEnabled()) break block17;
                LOG.debug("Unable to handle type " + clazz + " as POJO. Message: " + e.getMessage(), (Throwable)e);
            }
        }
        return new GenericTypeInfo<OUT>(clazz);
    }

    private boolean isValidPojoField(Field f, Class<?> clazz, ArrayList<Type> typeHierarchy) {
        if (Modifier.isPublic(f.getModifiers())) {
            return true;
        }
        boolean hasGetter = false;
        boolean hasSetter = false;
        String fieldNameLow = f.getName().toLowerCase().replaceAll("_", "");
        Type fieldType = f.getGenericType();
        Class fieldTypeWrapper = ClassUtils.primitiveToWrapper(f.getType());
        TypeVariable fieldTypeGeneric = null;
        if (fieldType instanceof TypeVariable) {
            fieldTypeGeneric = (TypeVariable)fieldType;
            fieldType = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)fieldType);
        }
        for (Method m : clazz.getMethods()) {
            String methodNameLow;
            String string = methodNameLow = m.getName().endsWith("_$eq") ? m.getName().toLowerCase().replaceAll("_", "").replaceFirst("\\$eq$", "_\\$eq") : m.getName().toLowerCase().replaceAll("_", "");
            if ((methodNameLow.equals("get" + fieldNameLow) || methodNameLow.equals("is" + fieldNameLow) || methodNameLow.equals(fieldNameLow)) && m.getParameterTypes().length == 0 && (m.getGenericReturnType().equals(fieldType) || fieldTypeWrapper != null && m.getReturnType().equals(fieldTypeWrapper) || fieldTypeGeneric != null && m.getGenericReturnType().equals(fieldTypeGeneric))) {
                if (hasGetter) {
                    throw new IllegalStateException("Detected more than one getter");
                }
                hasGetter = true;
            }
            if (!methodNameLow.equals("set" + fieldNameLow) && !methodNameLow.equals(fieldNameLow + "_$eq") || m.getParameterTypes().length != 1 || !m.getGenericParameterTypes()[0].equals(fieldType) && (fieldTypeWrapper == null || !m.getParameterTypes()[0].equals(fieldTypeWrapper)) && (fieldTypeGeneric == null || !m.getGenericParameterTypes()[0].equals(fieldTypeGeneric)) || !m.getReturnType().equals(Void.TYPE)) continue;
            if (hasSetter) {
                throw new IllegalStateException("Detected more than one setter");
            }
            hasSetter = true;
        }
        if (hasGetter && hasSetter) {
            return true;
        }
        if (!hasGetter) {
            LOG.debug(clazz + " does not contain a getter for field " + f.getName());
        }
        if (!hasSetter) {
            LOG.debug(clazz + " does not contain a setter for field " + f.getName());
        }
        return false;
    }

    protected <OUT, IN1, IN2> TypeInformation<OUT> analyzePojo(Class<OUT> clazz, ArrayList<Type> typeHierarchy, ParameterizedType parameterizedType, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            LOG.info("Class " + clazz.getName() + " is not public, cannot treat it as a POJO type. Will be handled as GenericType");
            return new GenericTypeInfo<OUT>(clazz);
        }
        if (parameterizedType != null) {
            TypeExtractor.getTypeHierarchy(typeHierarchy, parameterizedType, Object.class);
        } else if (typeHierarchy.size() <= 1) {
            TypeExtractor.getTypeHierarchy(typeHierarchy, clazz, Object.class);
        }
        List<Field> fields = TypeExtractor.getAllDeclaredFields(clazz);
        if (fields.size() == 0) {
            LOG.info("No fields detected for " + clazz + ". Cannot be used as a PojoType. Will be handled as GenericType");
            return new GenericTypeInfo<OUT>(clazz);
        }
        ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
        for (Field field : fields) {
            Type fieldType = field.getGenericType();
            if (!this.isValidPojoField(field, clazz, typeHierarchy)) {
                LOG.info(clazz + " is not a valid POJO type");
                return null;
            }
            try {
                ArrayList<Type> fieldTypeHierarchy = new ArrayList<Type>(typeHierarchy);
                fieldTypeHierarchy.add(fieldType);
                TypeInformation<OUT> ti = this.createTypeInfoWithTypeHierarchy(fieldTypeHierarchy, fieldType, in1Type, in2Type);
                pojoFields.add(new PojoField(field, ti));
            }
            catch (InvalidTypesException e) {
                Class genericClass = Object.class;
                if (TypeExtractor.isClassType(fieldType)) {
                    genericClass = TypeExtractor.typeToClass(fieldType);
                }
                pojoFields.add(new PojoField(field, new GenericTypeInfo<Object>(genericClass)));
            }
        }
        PojoTypeInfo<OUT> pojoType = new PojoTypeInfo<OUT>(clazz, pojoFields);
        List<Method> methods = TypeExtractor.getAllDeclaredMethods(clazz);
        for (Method method : methods) {
            if (!method.getName().equals("readObject") && !method.getName().equals("writeObject")) continue;
            LOG.info(clazz + " contains custom serialization methods we do not call.");
            return null;
        }
        Constructor<OUT> defaultConstructor = null;
        try {
            defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                LOG.info(clazz + " is abstract or an interface, having a concrete " + "type can increase performance.");
            }
            LOG.info(clazz + " must have a default constructor to be used as a POJO.");
            return null;
        }
        if (defaultConstructor != null && !Modifier.isPublic(defaultConstructor.getModifiers())) {
            LOG.info("The default constructor of " + clazz + " should be Public to be used as a POJO.");
            return null;
        }
        return pojoType;
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                if (TypeExtractor.hasFieldWithSameName(field.getName(), result)) {
                    throw new RuntimeException("The field " + field + " is already contained in the hierarchy of the " + clazz + "." + "Please use unique field names through your classes hierarchy");
                }
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        for (Field field : TypeExtractor.getAllDeclaredFields(clazz)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static boolean hasFieldWithSameName(String name, List<Field> fields) {
        for (Field field : fields) {
            if (!name.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private static List<Method> getAllDeclaredMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (clazz != null) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                result.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Class<?> typeToClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        throw new IllegalArgumentException("Cannot convert type to class");
    }

    public static boolean isClassType(Type t) {
        return t instanceof Class || t instanceof ParameterizedType;
    }

    private static boolean sameTypeVars(Type t1, Type t2) {
        if (!(t1 instanceof TypeVariable) || !(t2 instanceof TypeVariable)) {
            return false;
        }
        return ((TypeVariable)t1).getName().equals(((TypeVariable)t2).getName()) && ((TypeVariable)t1).getGenericDeclaration().equals(((TypeVariable)t2).getGenericDeclaration());
    }

    private static TypeInformation<?> getTypeOfPojoField(TypeInformation<?> pojoInfo, Field field) {
        for (int j = 0; j < pojoInfo.getArity(); ++j) {
            PojoField pf = ((PojoTypeInfo)pojoInfo).getPojoFieldAt(j);
            if (!pf.getField().getName().equals(field.getName())) continue;
            return pf.getTypeInformation();
        }
        return null;
    }

    public static <X> TypeInformation<X> getForObject(X value) {
        return new TypeExtractor().privateGetForObject(value);
    }

    private <X> TypeInformation<X> privateGetForObject(X value) {
        Preconditions.checkNotNull(value);
        if (value instanceof Tuple) {
            Tuple t = (Tuple)value;
            int numFields = t.getArity();
            if (numFields != this.countFieldsInClass(value.getClass())) {
                return this.analyzePojo(value.getClass(), new ArrayList<Type>(), null, null, null);
            }
            TypeInformation[] infos = new TypeInformation[numFields];
            for (int i = 0; i < numFields; ++i) {
                Object field = t.getField(i);
                if (field == null) {
                    throw new InvalidTypesException("Automatic type extraction is not possible on candidates with null values. Please specify the types directly.");
                }
                infos[i] = this.privateGetForObject(field);
            }
            return new TupleTypeInfo(value.getClass(), infos);
        }
        return this.privateGetForClass(value.getClass(), new ArrayList<Type>());
    }
}

