/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Array;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class ObjectArrayTypeInfo<T, C>
extends TypeInformation<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> arrayType;
    private final TypeInformation<C> componentInfo;

    private ObjectArrayTypeInfo(Class<T> arrayType, TypeInformation<C> componentInfo) {
        this.arrayType = Preconditions.checkNotNull(arrayType);
        this.componentInfo = Preconditions.checkNotNull(componentInfo);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.arrayType;
    }

    public TypeInformation<C> getComponentInfo() {
        return this.componentInfo;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return new GenericArraySerializer(this.componentInfo.getTypeClass(), this.componentInfo.createSerializer(executionConfig));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "<" + this.componentInfo + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)((Object)obj);
            return objectArrayTypeInfo.canEqual((Object)this) && this.arrayType == objectArrayTypeInfo.arrayType && this.componentInfo.equals(objectArrayTypeInfo.componentInfo);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ObjectArrayTypeInfo;
    }

    public int hashCode() {
        return 31 * this.arrayType.hashCode() + this.componentInfo.hashCode();
    }

    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(Class<T> arrayClass, TypeInformation<C> componentInfo) {
        Preconditions.checkNotNull(arrayClass);
        Preconditions.checkNotNull(componentInfo);
        Preconditions.checkArgument(arrayClass.isArray(), "Class " + arrayClass + " must be an array.");
        return new ObjectArrayTypeInfo<T, C>(arrayClass, componentInfo);
    }

    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(TypeInformation<C> componentInfo) {
        Preconditions.checkNotNull(componentInfo);
        return new ObjectArrayTypeInfo(Array.newInstance(componentInfo.getTypeClass(), 0).getClass(), componentInfo);
    }
}

