/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.GenericTypeComparator;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class GenericTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = -7959114120287706504L;
    private final Class<T> typeClass;

    public GenericTypeInfo(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return new KryoSerializer<T>(this.typeClass, config);
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (this.isKeyType()) {
            GenericTypeComparator<T> comparator = new GenericTypeComparator<T>(sortOrderAscending, this.createSerializer(executionConfig), this.typeClass);
            return comparator;
        }
        throw new UnsupportedOperationException("Types that do not implement java.lang.Comparable cannot be used as keys.");
    }

    public int hashCode() {
        return this.typeClass.hashCode();
    }

    public boolean canEqual(Object obj) {
        return obj instanceof GenericTypeInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenericTypeInfo) {
            GenericTypeInfo genericTypeInfo = (GenericTypeInfo)((Object)obj);
            return this.typeClass == genericTypeInfo.typeClass;
        }
        return false;
    }

    public String toString() {
        return "GenericType<" + this.typeClass.getCanonicalName() + ">";
    }
}

