/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.sca.TaggedValue;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.shaded.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.org.objectweb.asm.Type;
import org.apache.flink.shaded.org.objectweb.asm.tree.ClassNode;
import org.apache.flink.shaded.org.objectweb.asm.tree.MethodNode;
import org.apache.flink.shaded.org.objectweb.asm.tree.analysis.BasicValue;
import org.apache.flink.shaded.org.objectweb.asm.tree.analysis.Value;

public final class UdfAnalyzerUtils {
    public static TaggedValue convertTypeInfoToTaggedValue(TaggedValue.Input input, TypeInformation<?> typeInfo, String flatFieldExpr, List<CompositeType.FlatFieldDescriptor> flatFieldDesc, int[] groupedKeys) {
        if (typeInfo instanceof TupleTypeInfoBase) {
            TupleTypeInfoBase tupleTypeInfo = (TupleTypeInfoBase)typeInfo;
            HashMap<String, TaggedValue> containerMapping = new HashMap<String, TaggedValue>();
            for (int i = 0; i < tupleTypeInfo.getArity(); ++i) {
                String fieldName = typeInfo instanceof TupleTypeInfo ? "f" + i : "_" + (i + 1);
                containerMapping.put(fieldName, UdfAnalyzerUtils.convertTypeInfoToTaggedValue(input, tupleTypeInfo.getTypeAt(i), (flatFieldExpr.length() > 0 ? flatFieldExpr + "." : "") + fieldName, tupleTypeInfo.getFlatFields(fieldName), groupedKeys));
            }
            return new TaggedValue(Type.getObjectType("java/lang/Object"), containerMapping);
        }
        if (typeInfo instanceof PojoTypeInfo) {
            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInfo;
            HashMap<String, TaggedValue> containerMapping = new HashMap<String, TaggedValue>();
            for (int i = 0; i < pojoTypeInfo.getArity(); ++i) {
                String fieldName = pojoTypeInfo.getPojoFieldAt(i).getField().getName();
                containerMapping.put(fieldName, UdfAnalyzerUtils.convertTypeInfoToTaggedValue(input, pojoTypeInfo.getTypeAt(i), (flatFieldExpr.length() > 0 ? flatFieldExpr + "." : "") + fieldName, pojoTypeInfo.getFlatFields(fieldName), groupedKeys));
            }
            return new TaggedValue(Type.getObjectType("java/lang/Object"), containerMapping);
        }
        boolean groupedField = false;
        if (groupedKeys != null && flatFieldDesc != null) {
            int flatFieldPos = flatFieldDesc.get(0).getPosition();
            for (int groupedKey : groupedKeys) {
                if (groupedKey != flatFieldPos) continue;
                groupedField = true;
                break;
            }
        }
        return new TaggedValue(Type.getType(typeInfo.getTypeClass()), input, flatFieldExpr, groupedField, typeInfo.isBasicType() && typeInfo != BasicTypeInfo.DATE_TYPE_INFO);
    }

    public static Object[] findMethodNode(String internalClassName, Method method) {
        return UdfAnalyzerUtils.findMethodNode(internalClassName, method.getName(), Type.getMethodDescriptor(method));
    }

    public static Object[] findMethodNode(String internalClassName, String name, String desc) {
        InputStream stream = null;
        try {
            while (internalClassName != null) {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(internalClassName.replace('.', '/') + ".class");
                ClassReader cr = new ClassReader(stream);
                ClassNode cn = new ClassNode();
                cr.accept(cn, 0);
                for (MethodNode mn : cn.methods) {
                    if (!mn.name.equals(name) || !mn.desc.equals(desc)) continue;
                    Object[] objectArray = new Object[]{mn, cr.getClassName()};
                    return objectArray;
                }
                internalClassName = cr.getSuperName();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Method '" + name + "' could not be found", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IllegalStateException("Method '" + name + "' could not be found");
    }

    public static boolean isTagged(Value value) {
        return value != null && value instanceof TaggedValue;
    }

    public static TaggedValue tagged(Value value) {
        return (TaggedValue)value;
    }

    public static boolean hasImportantDependencies(List<? extends BasicValue> values, boolean skipFirst) {
        for (BasicValue basicValue : values) {
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            if (!UdfAnalyzerUtils.hasImportantDependencies(basicValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasImportantDependencies(BasicValue bv) {
        if (!UdfAnalyzerUtils.isTagged(bv)) {
            return false;
        }
        TaggedValue value = UdfAnalyzerUtils.tagged(bv);
        if (value.isInput() || value.isCollector()) {
            return true;
        }
        if (value.canContainFields() && value.getContainerMapping() != null) {
            for (TaggedValue tv : value.getContainerMapping().values()) {
                if (!UdfAnalyzerUtils.hasImportantDependencies(tv)) continue;
                return true;
            }
        }
        return false;
    }

    public static TaggedValue mergeInputs(List<TaggedValue> returnValues) {
        TaggedValue first = null;
        for (TaggedValue tv : returnValues) {
            if (first == null) {
                first = tv;
                continue;
            }
            if (first.equals(tv)) continue;
            return null;
        }
        return first;
    }

    public static TaggedValue mergeContainers(List<TaggedValue> returnValues) {
        if (returnValues.size() == 0) {
            return null;
        }
        Type returnType = null;
        HashSet<String> keys = null;
        for (TaggedValue tv : returnValues) {
            if (keys == null) {
                keys = new HashSet<String>(tv.getContainerMapping().keySet());
                returnType = tv.getType();
                continue;
            }
            keys.retainAll(tv.getContainerMapping().keySet());
        }
        HashMap<String, TaggedValue> resultMapping = new HashMap<String, TaggedValue>(keys.size());
        ArrayList<String> filteredMappings = new ArrayList<String>(keys.size());
        for (TaggedValue tv : returnValues) {
            Map<String, TaggedValue> cm = tv.getContainerMapping();
            for (String key : keys) {
                if (!cm.containsKey(key)) continue;
                if (!filteredMappings.contains(key) && cm.get(key) == null) {
                    filteredMappings.add(key);
                    continue;
                }
                if (!resultMapping.containsKey(key) && !filteredMappings.contains(key)) {
                    resultMapping.put(key, cm.get(key));
                    continue;
                }
                if (resultMapping.containsKey(key) && filteredMappings.contains(key)) {
                    resultMapping.remove(key);
                    continue;
                }
                if (!resultMapping.containsKey(key) || filteredMappings.contains(key) || cm.get(key).equals(resultMapping.get(key))) continue;
                filteredMappings.add(key);
                resultMapping.remove(key);
            }
        }
        Iterator it = resultMapping.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            TaggedValue value = UdfAnalyzerUtils.mergeReturnValues(Collections.singletonList(resultMapping.get(key)));
            if (value == null) {
                it.remove();
                continue;
            }
            resultMapping.put(key, value);
        }
        if (resultMapping.size() > 0) {
            return new TaggedValue(returnType, resultMapping);
        }
        return null;
    }

    public static TaggedValue mergeReturnValues(List<TaggedValue> returnValues) {
        if (returnValues.size() == 0 || returnValues.get(0) == null) {
            return null;
        }
        boolean allInputs = returnValues.get(0).isInput();
        for (TaggedValue tv : returnValues) {
            if (tv == null || tv.isInput() != allInputs) {
                return null;
            }
            if (!tv.canNotContainInput()) continue;
            return null;
        }
        if (allInputs) {
            return UdfAnalyzerUtils.mergeInputs(returnValues);
        }
        return UdfAnalyzerUtils.mergeContainers(returnValues);
    }

    public static void removeUngroupedInputsFromContainer(TaggedValue value) {
        if (value.getContainerMapping() != null) {
            Iterator<Map.Entry<String, TaggedValue>> it = value.getContainerMapping().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TaggedValue> entry = it.next();
                if (entry.getValue() == null) continue;
                if (entry.getValue().isInput() && !entry.getValue().isGrouped()) {
                    it.remove();
                    continue;
                }
                if (!entry.getValue().canContainFields()) continue;
                UdfAnalyzerUtils.removeUngroupedInputsFromContainer(entry.getValue());
            }
        }
    }

    public static TaggedValue removeUngroupedInputs(TaggedValue value) {
        if (value.isInput()) {
            if (value.isGrouped()) {
                return value;
            }
        } else if (value.canContainFields()) {
            UdfAnalyzerUtils.removeUngroupedInputsFromContainer(value);
            if (value.getContainerMapping() != null && value.getContainerMapping().size() > 0) {
                return value;
            }
        }
        return null;
    }

    private UdfAnalyzerUtils() {
        throw new RuntimeException();
    }
}

