/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueComparator;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueSerializer;
import org.apache.flink.api.java.typeutils.runtime.ValueComparator;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

public class ValueTypeInfo<T extends Value>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    public static final ValueTypeInfo<BooleanValue> BOOLEAN_VALUE_TYPE_INFO = new ValueTypeInfo<BooleanValue>(BooleanValue.class);
    public static final ValueTypeInfo<ByteValue> BYTE_VALUE_TYPE_INFO = new ValueTypeInfo<ByteValue>(ByteValue.class);
    public static final ValueTypeInfo<CharValue> CHAR_VALUE_TYPE_INFO = new ValueTypeInfo<CharValue>(CharValue.class);
    public static final ValueTypeInfo<DoubleValue> DOUBLE_VALUE_TYPE_INFO = new ValueTypeInfo<DoubleValue>(DoubleValue.class);
    public static final ValueTypeInfo<FloatValue> FLOAT_VALUE_TYPE_INFO = new ValueTypeInfo<FloatValue>(FloatValue.class);
    public static final ValueTypeInfo<IntValue> INT_VALUE_TYPE_INFO = new ValueTypeInfo<IntValue>(IntValue.class);
    public static final ValueTypeInfo<LongValue> LONG_VALUE_TYPE_INFO = new ValueTypeInfo<LongValue>(LongValue.class);
    public static final ValueTypeInfo<NullValue> NULL_VALUE_TYPE_INFO = new ValueTypeInfo<NullValue>(NullValue.class);
    public static final ValueTypeInfo<ShortValue> SHORT_VALUE_TYPE_INFO = new ValueTypeInfo<ShortValue>(ShortValue.class);
    public static final ValueTypeInfo<StringValue> STRING_VALUE_TYPE_INFO = new ValueTypeInfo<StringValue>(StringValue.class);
    private final Class<T> type;

    public ValueTypeInfo(Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
        Preconditions.checkArgument(Value.class.isAssignableFrom(type) || type.equals(Value.class), "ValueTypeInfo can only be used for subclasses of " + Value.class.getName());
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.type;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isBasicValueType() {
        return this.type.equals(StringValue.class) || this.type.equals(ByteValue.class) || this.type.equals(ShortValue.class) || this.type.equals(CharValue.class) || this.type.equals(DoubleValue.class) || this.type.equals(FloatValue.class) || this.type.equals(IntValue.class) || this.type.equals(LongValue.class) || this.type.equals(NullValue.class) || this.type.equals(BooleanValue.class);
    }

    public boolean isTupleType() {
        return false;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.type);
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        if (CopyableValue.class.isAssignableFrom(this.type)) {
            return ValueTypeInfo.createCopyableValueSerializer(this.type.asSubclass(CopyableValue.class));
        }
        return new ValueSerializer<T>(this.type);
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (!this.isKeyType()) {
            throw new RuntimeException("The type " + this.type.getName() + " is not Comparable.");
        }
        if (CopyableValue.class.isAssignableFrom(this.type)) {
            return new CopyableValueComparator<T>(sortOrderAscending, this.type);
        }
        return new ValueComparator<T>(sortOrderAscending, this.type);
    }

    private static <X extends CopyableValue<X>> CopyableValueSerializer<X> createCopyableValueSerializer(Class<X> clazz) {
        return new CopyableValueSerializer<X>(clazz);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueTypeInfo) {
            ValueTypeInfo valueTypeInfo = (ValueTypeInfo)((Object)obj);
            return valueTypeInfo.canEqual((Object)this) && this.type == valueTypeInfo.type;
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ValueTypeInfo;
    }

    public String toString() {
        return "ValueType<" + this.type.getSimpleName() + ">";
    }

    static <X extends Value> TypeInformation<X> getValueTypeInfo(Class<X> typeClass) {
        if (Value.class.isAssignableFrom(typeClass) && !typeClass.equals(Value.class)) {
            return new ValueTypeInfo<X>(typeClass);
        }
        throw new InvalidTypesException("The given class is no subclass of " + Value.class.getName());
    }
}

