/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.api.java.hadoop.common.HadoopOutputFormatCommonBase;
import org.apache.flink.api.java.hadoop.mapreduce.utils.HadoopUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

@Internal
public abstract class HadoopOutputFormatBase<K, V, T>
extends HadoopOutputFormatCommonBase<T>
implements FinalizeOnMaster {
    private static final long serialVersionUID = 1L;
    protected static final Object OPEN_MUTEX = new Object();
    protected static final Object CONFIGURE_MUTEX = new Object();
    protected static final Object CLOSE_MUTEX = new Object();
    protected org.apache.hadoop.conf.Configuration configuration;
    protected OutputFormat<K, V> mapreduceOutputFormat;
    protected transient RecordWriter<K, V> recordWriter;
    protected transient OutputCommitter outputCommitter;
    protected transient TaskAttemptContext context;
    protected transient int taskNumber;

    public HadoopOutputFormatBase(OutputFormat<K, V> mapreduceOutputFormat, Job job) {
        super(job.getCredentials());
        this.mapreduceOutputFormat = mapreduceOutputFormat;
        this.configuration = job.getConfiguration();
        HadoopUtils.mergeHadoopConf(this.configuration);
    }

    public org.apache.hadoop.conf.Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration parameters) {
        Object object = CONFIGURE_MUTEX;
        synchronized (object) {
            if (this.mapreduceOutputFormat instanceof Configurable) {
                ((Configurable)this.mapreduceOutputFormat).setConf(this.configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(OutputFormat.InitializationContext context) throws IOException {
        int taskNumber = context.getTaskNumber();
        Object object = OPEN_MUTEX;
        synchronized (object) {
            if (Integer.toString(taskNumber + 1).length() > 6) {
                throw new IOException("Task id too large.");
            }
            this.taskNumber = taskNumber + 1;
            this.configuration.set("mapreduce.output.basename", "tmp");
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)("attempt__0000_r_" + String.format("%" + (6 - Integer.toString(taskNumber + 1).length()) + "s", " ").replace(" ", "0") + Integer.toString(taskNumber + 1) + "_0"));
            this.configuration.set("mapred.task.id", taskAttemptID.toString());
            this.configuration.setInt("mapred.task.partition", taskNumber + 1);
            this.configuration.set("mapreduce.task.attempt.id", taskAttemptID.toString());
            this.configuration.setInt("mapreduce.task.partition", taskNumber + 1);
            try {
                this.context = new TaskAttemptContextImpl(this.configuration, taskAttemptID);
                this.outputCommitter = this.mapreduceOutputFormat.getOutputCommitter(this.context);
                this.outputCommitter.setupJob((JobContext)new JobContextImpl(this.configuration, new JobID()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.context.getCredentials().addAll(this.credentials);
            Credentials currentUserCreds = HadoopInputFormatCommonBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
            if (currentUserCreds != null) {
                this.context.getCredentials().addAll(currentUserCreds);
            }
            if (this.outputCommitter instanceof FileOutputCommitter) {
                this.configuration.set("mapreduce.task.output.dir", ((FileOutputCommitter)this.outputCommitter).getWorkPath().toString());
            }
            try {
                this.recordWriter = this.mapreduceOutputFormat.getRecordWriter(this.context);
            }
            catch (InterruptedException e) {
                throw new IOException("Could not create RecordWriter.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = CLOSE_MUTEX;
        synchronized (object) {
            try {
                this.recordWriter.close(this.context);
            }
            catch (InterruptedException e) {
                throw new IOException("Could not close RecordReader.", e);
            }
            if (this.outputCommitter.needsTaskCommit(this.context)) {
                this.outputCommitter.commitTask(this.context);
            }
            Path outputPath = new Path(this.configuration.get("mapred.output.dir"));
            FileSystem fs = FileSystem.get((URI)outputPath.toUri(), (org.apache.hadoop.conf.Configuration)this.configuration);
            String taskNumberStr = Integer.toString(this.taskNumber);
            String tmpFileTemplate = "tmp-r-00000";
            String tmpFile = tmpFileTemplate.substring(0, 11 - taskNumberStr.length()) + taskNumberStr;
            if (fs.exists(new Path(outputPath.toString() + "/" + tmpFile))) {
                fs.rename(new Path(outputPath.toString() + "/" + tmpFile), new Path(outputPath.toString() + "/" + taskNumberStr));
            }
        }
    }

    public void finalizeGlobal(FinalizeOnMaster.FinalizationContext context) throws IOException {
        JobContextImpl jobContext;
        try {
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)("attempt__0000_r_" + String.format("%" + (6 - Integer.toString(1).length()) + "s", " ").replace(" ", "0") + Integer.toString(1) + "_0"));
            jobContext = new JobContextImpl(this.configuration, new JobID());
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(this.configuration, taskAttemptID);
            this.outputCommitter = this.mapreduceOutputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        jobContext.getCredentials().addAll(this.credentials);
        Credentials currentUserCreds = HadoopInputFormatCommonBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            jobContext.getCredentials().addAll(currentUserCreds);
        }
        if (this.outputCommitter != null) {
            this.outputCommitter.commitJob((JobContext)jobContext);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeUTF(this.mapreduceOutputFormat.getClass().getName());
        this.configuration.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        String hadoopOutputFormatClassName = in.readUTF();
        org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration();
        configuration.readFields((DataInput)in);
        if (this.configuration == null) {
            this.configuration = configuration;
        }
        try {
            this.mapreduceOutputFormat = (OutputFormat)Class.forName(hadoopOutputFormatClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the hadoop output format", e);
        }
    }
}

