/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.hadoop.bulk.DefaultHadoopFileCommitterFactory;
import org.apache.flink.formats.hadoop.bulk.HadoopFileCommitterFactory;
import org.apache.flink.formats.hadoop.bulk.HadoopPathBasedBulkWriter;
import org.apache.flink.formats.hadoop.bulk.HadoopPathBasedPartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketFactory;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.DefaultBucketFactoryImpl;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.SerializableConfiguration;
import org.apache.flink.streaming.api.functions.sink.filesystem.legacy.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HadoopPathBasedBulkFormatBuilder<IN, BucketID, T extends HadoopPathBasedBulkFormatBuilder<IN, BucketID, T>>
extends StreamingFileSink.BucketsBuilder<IN, BucketID, T> {
    private static final long serialVersionUID = 1L;
    private final Path basePath;
    private HadoopPathBasedBulkWriter.Factory<IN> writerFactory;
    private HadoopFileCommitterFactory fileCommitterFactory;
    private SerializableConfiguration serializableConfiguration;
    private BucketAssigner<IN, BucketID> bucketAssigner;
    private CheckpointRollingPolicy<IN, BucketID> rollingPolicy;
    private BucketFactory<IN, BucketID> bucketFactory;
    private OutputFileConfig outputFileConfig;

    public HadoopPathBasedBulkFormatBuilder(org.apache.hadoop.fs.Path basePath, HadoopPathBasedBulkWriter.Factory<IN> writerFactory, Configuration configuration, BucketAssigner<IN, BucketID> assigner) {
        this(basePath, writerFactory, new DefaultHadoopFileCommitterFactory(), configuration, assigner, (CheckpointRollingPolicy<IN, BucketID>)OnCheckpointRollingPolicy.build(), (BucketFactory<IN, BucketID>)new DefaultBucketFactoryImpl(), OutputFileConfig.builder().build());
    }

    public HadoopPathBasedBulkFormatBuilder(org.apache.hadoop.fs.Path basePath, HadoopPathBasedBulkWriter.Factory<IN> writerFactory, HadoopFileCommitterFactory fileCommitterFactory, Configuration configuration, BucketAssigner<IN, BucketID> assigner, CheckpointRollingPolicy<IN, BucketID> policy, BucketFactory<IN, BucketID> bucketFactory, OutputFileConfig outputFileConfig) {
        this.basePath = new Path(((org.apache.hadoop.fs.Path)Preconditions.checkNotNull((Object)basePath)).toString());
        this.writerFactory = writerFactory;
        this.fileCommitterFactory = fileCommitterFactory;
        this.serializableConfiguration = new SerializableConfiguration(configuration);
        this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(assigner);
        this.rollingPolicy = (CheckpointRollingPolicy)Preconditions.checkNotNull(policy);
        this.bucketFactory = (BucketFactory)Preconditions.checkNotNull(bucketFactory);
        this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
    }

    public T withBucketAssigner(BucketAssigner<IN, BucketID> assigner) {
        this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(assigner);
        return (T)((Object)((HadoopPathBasedBulkFormatBuilder)this.self()));
    }

    public T withRollingPolicy(CheckpointRollingPolicy<IN, BucketID> rollingPolicy) {
        this.rollingPolicy = (CheckpointRollingPolicy)Preconditions.checkNotNull(rollingPolicy);
        return (T)((Object)((HadoopPathBasedBulkFormatBuilder)this.self()));
    }

    public T withBucketFactory(BucketFactory<IN, BucketID> factory) {
        this.bucketFactory = (BucketFactory)Preconditions.checkNotNull(factory);
        return (T)((Object)((HadoopPathBasedBulkFormatBuilder)this.self()));
    }

    public T withOutputFileConfig(OutputFileConfig outputFileConfig) {
        this.outputFileConfig = outputFileConfig;
        return (T)((Object)((HadoopPathBasedBulkFormatBuilder)this.self()));
    }

    public T withConfiguration(Configuration configuration) {
        this.serializableConfiguration = new SerializableConfiguration(configuration);
        return (T)((Object)((HadoopPathBasedBulkFormatBuilder)this.self()));
    }

    public BucketWriter<IN, BucketID> createBucketWriter() {
        return new HadoopPathBasedPartFileWriter.HadoopPathBasedBucketWriter(this.serializableConfiguration.getConfiguration(), this.writerFactory, this.fileCommitterFactory);
    }

    public Buckets<IN, BucketID> createBuckets(int subtaskIndex) throws IOException {
        return new Buckets(this.basePath, this.bucketAssigner, this.bucketFactory, this.createBucketWriter(), this.rollingPolicy, subtaskIndex, this.outputFileConfig);
    }
}

