/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.MonitoredResource;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.GroupServiceClient;
import com.google.cloud.monitoring.v3.stub.GroupServiceStub;
import com.google.cloud.monitoring.v3.stub.GrpcGroupServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class GroupServiceStubSettings
extends StubSettings<GroupServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/monitoring")).add("https://www.googleapis.com/auth/monitoring.read")).add("https://www.googleapis.com/auth/monitoring.write")).build();
    private final PagedCallSettings<ListGroupsRequest, ListGroupsResponse, GroupServiceClient.ListGroupsPagedResponse> listGroupsSettings;
    private final UnaryCallSettings<GetGroupRequest, Group> getGroupSettings;
    private final UnaryCallSettings<CreateGroupRequest, Group> createGroupSettings;
    private final UnaryCallSettings<UpdateGroupRequest, Group> updateGroupSettings;
    private final UnaryCallSettings<DeleteGroupRequest, Empty> deleteGroupSettings;
    private final PagedCallSettings<ListGroupMembersRequest, ListGroupMembersResponse, GroupServiceClient.ListGroupMembersPagedResponse> listGroupMembersSettings;
    private static final PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group> LIST_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListGroupsRequest injectToken(ListGroupsRequest payload, String token) {
            return ListGroupsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListGroupsRequest injectPageSize(ListGroupsRequest payload, int pageSize) {
            return ListGroupsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListGroupsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Group> extractResources(ListGroupsResponse payload) {
            return payload.getGroupList() != null ? payload.getGroupList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> LIST_GROUP_MEMBERS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListGroupMembersRequest injectToken(ListGroupMembersRequest payload, String token) {
            return ListGroupMembersRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListGroupMembersRequest injectPageSize(ListGroupMembersRequest payload, int pageSize) {
            return ListGroupMembersRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListGroupMembersRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListGroupMembersResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<MonitoredResource> extractResources(ListGroupMembersResponse payload) {
            return payload.getMembersList() != null ? payload.getMembersList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, GroupServiceClient.ListGroupsPagedResponse> LIST_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, GroupServiceClient.ListGroupsPagedResponse>(){

        @Override
        public ApiFuture<GroupServiceClient.ListGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupsRequest, ListGroupsResponse> callable, ListGroupsRequest request, ApiCallContext context, ApiFuture<ListGroupsResponse> futureResponse) {
            PageContext<ListGroupsRequest, ListGroupsResponse, Group> pageContext = PageContext.create(callable, LIST_GROUPS_PAGE_STR_DESC, request, context);
            return GroupServiceClient.ListGroupsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGroupMembersRequest, ListGroupMembersResponse, GroupServiceClient.ListGroupMembersPagedResponse> LIST_GROUP_MEMBERS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupMembersRequest, ListGroupMembersResponse, GroupServiceClient.ListGroupMembersPagedResponse>(){

        @Override
        public ApiFuture<GroupServiceClient.ListGroupMembersPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> callable, ListGroupMembersRequest request, ApiCallContext context, ApiFuture<ListGroupMembersResponse> futureResponse) {
            PageContext<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> pageContext = PageContext.create(callable, LIST_GROUP_MEMBERS_PAGE_STR_DESC, request, context);
            return GroupServiceClient.ListGroupMembersPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGroupsRequest, ListGroupsResponse, GroupServiceClient.ListGroupsPagedResponse> listGroupsSettings() {
        return this.listGroupsSettings;
    }

    public UnaryCallSettings<GetGroupRequest, Group> getGroupSettings() {
        return this.getGroupSettings;
    }

    public UnaryCallSettings<CreateGroupRequest, Group> createGroupSettings() {
        return this.createGroupSettings;
    }

    public UnaryCallSettings<UpdateGroupRequest, Group> updateGroupSettings() {
        return this.updateGroupSettings;
    }

    public UnaryCallSettings<DeleteGroupRequest, Empty> deleteGroupSettings() {
        return this.deleteGroupSettings;
    }

    public PagedCallSettings<ListGroupMembersRequest, ListGroupMembersResponse, GroupServiceClient.ListGroupMembersPagedResponse> listGroupMembersSettings() {
        return this.listGroupMembersSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GroupServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGroupServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GroupServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GroupServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GroupServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.listGroupsSettings = settingsBuilder.listGroupsSettings().build();
        this.getGroupSettings = settingsBuilder.getGroupSettings().build();
        this.createGroupSettings = settingsBuilder.createGroupSettings().build();
        this.updateGroupSettings = settingsBuilder.updateGroupSettings().build();
        this.deleteGroupSettings = settingsBuilder.deleteGroupSettings().build();
        this.listGroupMembersSettings = settingsBuilder.listGroupMembersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GroupServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, GroupServiceClient.ListGroupsPagedResponse> listGroupsSettings;
        private final UnaryCallSettings.Builder<GetGroupRequest, Group> getGroupSettings;
        private final UnaryCallSettings.Builder<CreateGroupRequest, Group> createGroupSettings;
        private final UnaryCallSettings.Builder<UpdateGroupRequest, Group> updateGroupSettings;
        private final UnaryCallSettings.Builder<DeleteGroupRequest, Empty> deleteGroupSettings;
        private final PagedCallSettings.Builder<ListGroupMembersRequest, ListGroupMembersResponse, GroupServiceClient.ListGroupMembersPagedResponse> listGroupMembersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGroupsSettings = PagedCallSettings.newBuilder(LIST_GROUPS_PAGE_STR_FACT);
            this.getGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGroupMembersSettings = PagedCallSettings.newBuilder(LIST_GROUP_MEMBERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupsSettings, this.getGroupSettings, this.createGroupSettings, this.updateGroupSettings, this.deleteGroupSettings, this.listGroupMembersSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GroupServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(GroupServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(GroupServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GroupServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            ((PagedCallSettings.Builder)builder.listGroupsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.getGroupSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.createGroupSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.updateGroupSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.deleteGroupSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            ((PagedCallSettings.Builder)builder.listGroupMembersSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            return builder;
        }

        protected Builder(GroupServiceStubSettings settings) {
            super(settings);
            this.listGroupsSettings = settings.listGroupsSettings.toBuilder();
            this.getGroupSettings = settings.getGroupSettings.toBuilder();
            this.createGroupSettings = settings.createGroupSettings.toBuilder();
            this.updateGroupSettings = settings.updateGroupSettings.toBuilder();
            this.deleteGroupSettings = settings.deleteGroupSettings.toBuilder();
            this.listGroupMembersSettings = settings.listGroupMembersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupsSettings, this.getGroupSettings, this.createGroupSettings, this.updateGroupSettings, this.deleteGroupSettings, this.listGroupMembersSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, GroupServiceClient.ListGroupsPagedResponse> listGroupsSettings() {
            return this.listGroupsSettings;
        }

        public UnaryCallSettings.Builder<GetGroupRequest, Group> getGroupSettings() {
            return this.getGroupSettings;
        }

        public UnaryCallSettings.Builder<CreateGroupRequest, Group> createGroupSettings() {
            return this.createGroupSettings;
        }

        public UnaryCallSettings.Builder<UpdateGroupRequest, Group> updateGroupSettings() {
            return this.updateGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteGroupRequest, Empty> deleteGroupSettings() {
            return this.deleteGroupSettings;
        }

        public PagedCallSettings.Builder<ListGroupMembersRequest, ListGroupMembersResponse, GroupServiceClient.ListGroupMembersPagedResponse> listGroupMembersSettings() {
            return this.listGroupMembersSettings;
        }

        public GroupServiceStubSettings build() throws IOException {
            return new GroupServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("idempotent", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE)));
            definitions.put("non_idempotent", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(20000L)).setTotalTimeout(Duration.ofMillis(600000L)).build();
            definitions.put("default", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

