/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.cooplock;

import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecord;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class CoopLockRecords {
    public static final long FORMAT_VERSION = 3L;
    private long formatVersion = -1L;
    private Set<CoopLockRecord> locks = new TreeSet<CoopLockRecord>(Comparator.comparing(CoopLockRecord::getOperationId));

    public long getFormatVersion() {
        return this.formatVersion;
    }

    public CoopLockRecords setFormatVersion(long formatVersion) {
        this.formatVersion = formatVersion;
        return this;
    }

    public Set<CoopLockRecord> getLocks() {
        Preconditions.checkState(3L == this.formatVersion, "%s operation lock version is not supported, supported version is %s", this.formatVersion, 3L);
        return this.locks;
    }

    public CoopLockRecords setLocks(Set<CoopLockRecord> locks) {
        this.locks = new TreeSet<CoopLockRecord>(Comparator.comparing(CoopLockRecord::getOperationId));
        this.locks.addAll(locks);
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("formatVersion", this.formatVersion).add("operations", this.locks).toString();
    }
}

