/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing.util;

import java.util.Arrays;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.connector.datagen.source.GeneratorFunction;

public class CarGeneratorFunction
implements GeneratorFunction<Long, Tuple4<Integer, Integer, Double, Long>> {
    private static final long serialVersionUID = 1L;
    private final int[] speeds;
    private final double[] distances;
    private final long[] lastUpdate;
    private int nextCar;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final double HOURS_IN_MILLI = 2.7777777777777776E-7;
    private static final int METERS_IN_KILOMETER = 1000;
    private final Random rand = new Random();
    private static final int COMPAT_FACTOR = 10;

    public CarGeneratorFunction(int numOfCars) {
        this.speeds = new int[numOfCars];
        this.distances = new double[numOfCars];
        this.lastUpdate = new long[numOfCars];
        Arrays.fill(this.speeds, 50);
        Arrays.fill(this.distances, 0.0);
        Arrays.fill(this.lastUpdate, 0L);
    }

    public Tuple4<Integer, Integer, Double, Long> map(Long ignoredIndex) throws Exception {
        this.speeds[this.nextCar] = this.rand.nextBoolean() ? Math.min(100, this.speeds[this.nextCar] + 5) : Math.max(0, this.speeds[this.nextCar] - 5);
        long now = System.currentTimeMillis();
        long timeDiffMillis = this.lastUpdate[this.nextCar] == 0L ? 0L : now - this.lastUpdate[this.nextCar];
        this.lastUpdate[this.nextCar] = now;
        int n = this.nextCar;
        this.distances[n] = this.distances[n] + (double)this.speeds[this.nextCar] * ((double)timeDiffMillis * 2.7777777777777776E-7) * 1000.0 * 10.0;
        ++this.nextCar;
        this.nextCar %= this.speeds.length;
        return new Tuple4((Object)this.nextCar, (Object)this.speeds[this.nextCar], (Object)this.distances[this.nextCar], (Object)now);
    }
}

