/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.datagen;

import java.io.Serializable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.connector.datagen.source.DataGeneratorSource;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public class DataGeneratorPerCheckpoint {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(3000L);
        env.setParallelism(1);
        String[] elements = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
        int size = elements.length;
        GeneratorFunction & Serializable generatorFunction = (GeneratorFunction & Serializable)index -> elements[(int)(index % (long)size)];
        DataGeneratorSource generatorSource = new DataGeneratorSource((GeneratorFunction)generatorFunction, Long.MAX_VALUE, RateLimiterStrategy.perCheckpoint((int)size), Types.STRING);
        DataStreamSource streamSource = env.fromSource((Source)generatorSource, WatermarkStrategy.noWatermarks(), "Data Generator");
        streamSource.print();
        env.execute("Data Generator Source Example");
    }
}

