/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiFunction;
import org.apache.flink.changelog.fs.OutputStreamWithPos;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DuplicatingOutputStreamWithPos
extends OutputStreamWithPos {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicatingOutputStreamWithPos.class);
    private OutputStream secondaryStream;
    private OutputStream originalSecondaryStream;
    private final Path secondaryPath;
    private Exception secondaryStreamException;

    public DuplicatingOutputStreamWithPos(OutputStream primaryStream, Path primaryPath, OutputStream secondaryStream, Path secondaryPath) {
        super(primaryStream, primaryPath);
        this.secondaryStream = (OutputStream)Preconditions.checkNotNull((Object)secondaryStream);
        this.originalSecondaryStream = (OutputStream)Preconditions.checkNotNull((Object)secondaryStream);
        this.secondaryPath = (Path)Preconditions.checkNotNull((Object)secondaryPath);
    }

    @Override
    public void wrap(boolean compression, int bufferSize) throws IOException {
        super.wrap(compression, bufferSize);
        this.secondaryStream = this.wrapInternal(compression, bufferSize, this.originalSecondaryStream);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryStream.write(b);
            }
            catch (Exception ex) {
                this.handleSecondaryStreamOnException(ex);
            }
        }
        ++this.pos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryStream.write(b);
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered during write to secondary stream");
                this.handleSecondaryStreamOnException(ex);
            }
        }
        this.pos += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryStream.write(b, off, len);
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered during writing to secondary stream");
                this.handleSecondaryStreamOnException(ex);
            }
        }
        this.pos += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryStream.flush();
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered during flushing secondary stream");
                this.handleSecondaryStreamOnException(ex);
            }
        }
    }

    @Override
    public void close() throws IOException {
        Exception exCollector = null;
        try {
            super.close();
        }
        catch (Exception closeEx) {
            exCollector = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)closeEx, exCollector);
        }
        if (this.secondaryStreamException == null) {
            try {
                this.secondaryStream.close();
                this.originalSecondaryStream.close();
            }
            catch (Exception closeEx) {
                this.getSecondaryPath().getFileSystem().delete(this.getSecondaryPath(), true);
                this.handleSecondaryStreamOnException(closeEx);
            }
        }
        if (exCollector != null) {
            throw new IOException("Exception while closing duplicating stream.", exCollector);
        }
    }

    private void handleSecondaryStreamOnException(Exception ex) {
        Preconditions.checkState((this.secondaryStreamException == null ? 1 : 0) != 0, (Object)"Secondary stream already failed from previous exception!");
        try {
            this.secondaryStream.close();
        }
        catch (Exception closeEx) {
            ex = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)closeEx, (Throwable)ex);
        }
        this.secondaryStreamException = (Exception)Preconditions.checkNotNull((Object)ex);
    }

    public Path getSecondaryPath() {
        return this.secondaryPath;
    }

    public StreamStateHandle getSecondaryHandle(BiFunction<Path, Long, StreamStateHandle> handleFactory) throws IOException {
        if (this.secondaryStreamException == null) {
            return handleFactory.apply(this.secondaryPath, this.pos);
        }
        throw new IOException("Secondary stream previously failed exceptionally", this.secondaryStreamException);
    }
}

