/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.context.TwoOutputPartitionedContext;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.context.DefaultProcessingTimeManager;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.operators.BaseKeyedTwoOutputProcessOperator;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class KeyedTwoOutputProcessOperator<KEY, IN, OUT_MAIN, OUT_SIDE>
extends BaseKeyedTwoOutputProcessOperator<KEY, IN, OUT_MAIN, OUT_SIDE>
implements Triggerable<KEY, VoidNamespace> {
    private transient InternalTimerService<VoidNamespace> timerService;

    public KeyedTwoOutputProcessOperator(TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE> userFunction, OutputTag<OUT_SIDE> outputTag) {
        this(userFunction, outputTag, null, null);
    }

    public KeyedTwoOutputProcessOperator(TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE> userFunction, OutputTag<OUT_SIDE> outputTag, @Nullable KeySelector<OUT_MAIN, KEY> mainOutKeySelector, @Nullable KeySelector<OUT_SIDE, KEY> sideOutKeySelector) {
        super(userFunction, outputTag, mainOutKeySelector, sideOutKeySelector);
        Preconditions.checkArgument((mainOutKeySelector == null && sideOutKeySelector == null || mainOutKeySelector != null && sideOutKeySelector != null ? 1 : 0) != 0, (Object)"Both mainOutKeySelector and sideOutKeySelector must be null or not null.");
    }

    @Override
    public void open() throws Exception {
        this.timerService = this.getInternalTimerService("processing timer", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        super.open();
    }

    @Override
    protected ProcessingTimeManager getProcessingTimeManager() {
        return new DefaultProcessingTimeManager(this.timerService);
    }

    public void onEventTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        if (this.userFunction instanceof EventTimeWrappedTwoOutputStreamProcessFunction) {
            ((EventTimeWrappedTwoOutputStreamProcessFunction)this.userFunction).onEventTime(timer.getTimestamp(), this.getMainCollector(), this.getSideCollector(), this.partitionedContext);
        }
    }

    public void onProcessingTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        ((TwoOutputStreamProcessFunction)this.userFunction).onProcessingTimer(timer.getTimestamp(), this.getMainCollector(), this.getSideCollector(), (TwoOutputPartitionedContext)this.partitionedContext);
    }

    @Override
    protected InternalTimerService<VoidNamespace> getTimerService() {
        return this.timerService;
    }

    @Override
    protected Supplier<Long> getEventTimeSupplier() {
        return () -> this.timerService.currentWatermark();
    }
}

