/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.common.KeyCheckedOutputCollector;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultProcessingTimeManager;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.operators.TwoInputBroadcastProcessOperator;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;

public class KeyedTwoInputBroadcastProcessOperator<KEY, IN1, IN2, OUT>
extends TwoInputBroadcastProcessOperator<IN1, IN2, OUT>
implements Triggerable<KEY, VoidNamespace> {
    private transient InternalTimerService<VoidNamespace> timerService;
    private transient Set<Object> keySet;
    @Nullable
    private final KeySelector<OUT, KEY> outKeySelector;

    public KeyedTwoInputBroadcastProcessOperator(TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction) {
        this(userFunction, null);
    }

    public KeyedTwoInputBroadcastProcessOperator(TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction, @Nullable KeySelector<OUT, KEY> outKeySelector) {
        super(userFunction);
        this.outKeySelector = outKeySelector;
    }

    @Override
    public void open() throws Exception {
        this.timerService = this.getInternalTimerService("processing timer", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        this.keySet = new HashSet<Object>();
        super.open();
    }

    @Override
    protected TimestampCollector<OUT> getOutputCollector() {
        return this.outKeySelector == null ? new OutputCollector(this.output) : new KeyCheckedOutputCollector(new OutputCollector(this.output), this.outKeySelector, () -> this.getCurrentKey());
    }

    @Override
    protected Object currentKey() {
        return this.getCurrentKey();
    }

    @Override
    protected ProcessingTimeManager getProcessingTimeManager() {
        return new DefaultProcessingTimeManager(this.timerService);
    }

    public void onEventTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        if (this.userFunction instanceof EventTimeWrappedTwoInputBroadcastStreamProcessFunction) {
            ((EventTimeWrappedTwoInputBroadcastStreamProcessFunction)this.userFunction).onEventTime(timer.getTimestamp(), this.getOutputCollector(), this.partitionedContext);
        }
    }

    public void onProcessingTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).onProcessingTimer(timer.getTimestamp(), this.getOutputCollector(), (PartitionedContext)this.partitionedContext);
    }

    @Override
    protected NonPartitionedContext<OUT> getNonPartitionedContext() {
        return new DefaultNonPartitionedContext(this.context, this.partitionedContext, this.collector, true, this.keySet, this.output, this.watermarkDeclarationMap);
    }

    public void newKeySelected(Object newKey) {
        this.keySet.add(newKey);
    }

    @Override
    public boolean isAsyncStateProcessingEnabled() {
        return true;
    }

    @Override
    protected InternalTimerService<VoidNamespace> getTimerService() {
        return this.timerService;
    }

    @Override
    protected Supplier<Long> getEventTimeSupplier() {
        return () -> this.timerService.currentWatermark();
    }
}

