/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.api.extension.eventtime.strategy;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.datastream.api.extension.eventtime.strategy.EventTimeExtractor;

@Experimental
public class EventTimeWatermarkStrategy<T>
implements Serializable {
    private final EventTimeExtractor<T> eventTimeExtractor;
    private final EventTimeWatermarkGenerateMode generateMode;
    private final Duration periodicWatermarkInterval;
    private final Duration idleTimeout;
    private final Duration maxOutOfOrderTime;

    public EventTimeWatermarkStrategy(EventTimeExtractor<T> eventTimeExtractor) {
        this(eventTimeExtractor, EventTimeWatermarkGenerateMode.PERIODIC, Duration.ZERO, Duration.ZERO, Duration.ZERO);
    }

    public EventTimeWatermarkStrategy(EventTimeExtractor<T> eventTimeExtractor, EventTimeWatermarkGenerateMode generateMode, Duration periodicWatermarkInterval, Duration idleTimeout, Duration maxOutOfOrderTime) {
        this.eventTimeExtractor = eventTimeExtractor;
        this.generateMode = generateMode;
        this.periodicWatermarkInterval = periodicWatermarkInterval;
        this.idleTimeout = idleTimeout;
        this.maxOutOfOrderTime = maxOutOfOrderTime;
    }

    public EventTimeExtractor<T> getEventTimeExtractor() {
        return this.eventTimeExtractor;
    }

    public EventTimeWatermarkGenerateMode getGenerateMode() {
        return this.generateMode;
    }

    public Duration getPeriodicWatermarkInterval() {
        return this.periodicWatermarkInterval;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public Duration getMaxOutOfOrderTime() {
        return this.maxOutOfOrderTime;
    }

    @Internal
    public static enum EventTimeWatermarkGenerateMode {
        NO_WATERMARK,
        PERIODIC,
        PER_EVENT;

    }
}

