/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.environment;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class TestEnvironmentSettings {
    private final List<URL> connectorJarPaths;
    @Nullable
    private final String savepointRestorePath;

    public static Builder builder() {
        return new Builder();
    }

    private TestEnvironmentSettings(List<URL> connectorJarPaths, @Nullable String savepointRestorePath) {
        this.connectorJarPaths = connectorJarPaths;
        this.savepointRestorePath = savepointRestorePath;
    }

    public List<URL> getConnectorJarPaths() {
        return this.connectorJarPaths;
    }

    @Nullable
    public String getSavepointRestorePath() {
        return this.savepointRestorePath;
    }

    public static class Builder {
        private final List<URL> connectorJarPaths = new ArrayList<URL>();
        private String savepointRestorePath;

        public Builder setConnectorJarPaths(List<URL> connectorJarPaths) {
            this.connectorJarPaths.addAll(connectorJarPaths);
            return this;
        }

        public Builder setConnectorJarPaths(URL ... connectorJarPaths) {
            this.connectorJarPaths.addAll(Arrays.asList(connectorJarPaths));
            return this;
        }

        public Builder setSavepointRestorePath(String savepointRestorePath) {
            this.savepointRestorePath = savepointRestorePath;
            return this;
        }

        public TestEnvironmentSettings build() {
            return new TestEnvironmentSettings(this.connectorJarPaths, this.savepointRestorePath);
        }
    }
}

