/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.table;

import java.time.Duration;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.base.options.JdbcSourceOptions;
import org.apache.flink.cdc.connectors.base.options.SourceOptions;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.utils.ObjectUtils;
import org.apache.flink.cdc.connectors.base.utils.OptionUtils;
import org.apache.flink.cdc.connectors.sqlserver.table.SqlServerTableSource;
import org.apache.flink.cdc.debezium.table.DebeziumOptions;
import org.apache.flink.cdc.debezium.utils.ResolvedSchemaUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class SqlServerTableFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "sqlserver-cdc";
    private static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the SqlServer database server.");
    private static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)1433).withDescription("Integer port number of the SqlServer database server.");
    private static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the SqlServer database to use when connecting to the SqlServer database server.");
    private static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the SqlServer database server.");
    private static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the SqlServer server to monitor.");
    private static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the SqlServer database to monitor.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for SqlServer CDC consumer, valid enumerations are \"initial\" and \"latest-offset\"");
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(HOSTNAME);
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String databaseName = (String)config.get(DATABASE_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        ZoneId serverTimeZone = ZoneId.of((String)config.get(SERVER_TIME_ZONE));
        int port = (Integer)config.get(PORT);
        StartupOptions startupOptions = SqlServerTableFactory.getStartupOptions(config);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)context.getCatalogTable().getResolvedSchema());
        boolean enableParallelRead = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        int splitSize = (Integer)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        int splitMetaGroupSize = (Integer)config.get(SourceOptions.CHUNK_META_GROUP_SIZE);
        int fetchSize = (Integer)config.get(SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        Duration connectTimeout = (Duration)config.get(JdbcSourceOptions.CONNECT_TIMEOUT);
        int connectMaxRetries = (Integer)config.get(JdbcSourceOptions.CONNECT_MAX_RETRIES);
        int connectionPoolSize = (Integer)config.get(JdbcSourceOptions.CONNECTION_POOL_SIZE);
        double distributionFactorUpper = (Double)config.get(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        double distributionFactorLower = (Double)config.get(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        String chunkKeyColumn = config.getOptional(JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN).orElse(null);
        boolean closeIdleReaders = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED);
        boolean skipSnapshotBackfill = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP);
        boolean assignUnboundedChunkFirst = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_UNBOUNDED_CHUNK_FIRST_ENABLED);
        if (enableParallelRead) {
            this.validateIntegerOption((ConfigOption<Integer>)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE, splitSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE, fetchSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)SourceOptions.CHUNK_META_GROUP_SIZE, splitMetaGroupSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)JdbcSourceOptions.CONNECTION_POOL_SIZE, connectionPoolSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)JdbcSourceOptions.CONNECT_MAX_RETRIES, connectMaxRetries, 0);
            this.validateDistributionFactorUpper(distributionFactorUpper);
            this.validateDistributionFactorLower(distributionFactorLower);
        }
        OptionUtils.printOptions((String)IDENTIFIER, (Map)((Configuration)config).toMap());
        return new SqlServerTableSource(physicalSchema, port, hostname, databaseName, tableName, serverTimeZone, username, password, DebeziumOptions.getDebeziumProperties((Map)context.getCatalogTable().getOptions()), startupOptions, enableParallelRead, splitSize, splitMetaGroupSize, fetchSize, connectTimeout, connectMaxRetries, connectionPoolSize, distributionFactorUpper, distributionFactorLower, chunkKeyColumn, closeIdleReaders, skipSnapshotBackfill, assignUnboundedChunkFirst);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(HOSTNAME);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(DATABASE_NAME);
        options.add(TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PORT);
        options.add(SERVER_TIME_ZONE);
        options.add(SCAN_STARTUP_MODE);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        options.add(SourceOptions.CHUNK_META_GROUP_SIZE);
        options.add(SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        options.add(JdbcSourceOptions.CONNECT_TIMEOUT);
        options.add(JdbcSourceOptions.CONNECT_MAX_RETRIES);
        options.add(JdbcSourceOptions.CONNECTION_POOL_SIZE);
        options.add(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        options.add(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        options.add(JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN);
        options.add(SourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_UNBOUNDED_CHUNK_FIRST_ENABLED);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s], but was: %s", SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }

    private void validateIntegerOption(ConfigOption<Integer> option, int optionValue, int exclusiveMin) {
        Preconditions.checkState((optionValue > exclusiveMin ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than %d, but is %d", option.key(), exclusiveMin, optionValue));
    }

    private void validateDistributionFactorUpper(double distributionFactorUpper) {
        Preconditions.checkState((ObjectUtils.doubleCompare((double)distributionFactorUpper, (double)1.0) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than or equals %s, but is %s", SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.key(), 1.0, distributionFactorUpper));
    }

    private void validateDistributionFactorLower(double distributionFactorLower) {
        Preconditions.checkState((ObjectUtils.doubleCompare((double)distributionFactorLower, (double)0.0) >= 0 && ObjectUtils.doubleCompare((double)distributionFactorLower, (double)1.0) <= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must between %s and %s inclusively, but is %s", SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.key(), 0.0, 1.0, distributionFactorLower));
    }
}

