/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.config;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;

public class PostgresSourceConfig
extends JdbcSourceConfig {
    private static final long serialVersionUID = 1L;
    private final int subtaskId;
    private final int lsnCommitCheckpointsDelay;

    public PostgresSourceConfig(int subtaskId, StartupOptions startupOptions, List<String> databaseList, List<String> schemaList, List<String> tableList, int splitSize, int splitMetaGroupSize, double distributionFactorUpper, double distributionFactorLower, boolean includeSchemaChanges, boolean closeIdleReaders, Properties dbzProperties, Configuration dbzConfiguration, String driverClassName, String hostname, int port, String username, String password, int fetchSize, String serverTimeZone, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, @Nullable String chunkKeyColumn, boolean skipSnapshotBackfill, boolean isScanNewlyAddedTableEnabled, int lsnCommitCheckpointsDelay) {
        super(startupOptions, databaseList, schemaList, tableList, splitSize, splitMetaGroupSize, distributionFactorUpper, distributionFactorLower, includeSchemaChanges, closeIdleReaders, dbzProperties, dbzConfiguration, driverClassName, hostname, port, username, password, fetchSize, serverTimeZone, connectTimeout, connectMaxRetries, connectionPoolSize, chunkKeyColumn, skipSnapshotBackfill, isScanNewlyAddedTableEnabled);
        this.subtaskId = subtaskId;
        this.lsnCommitCheckpointsDelay = lsnCommitCheckpointsDelay;
    }

    public int getSubtaskId() {
        return this.subtaskId;
    }

    public int getLsnCommitCheckpointsDelay() {
        return this.lsnCommitCheckpointsDelay;
    }

    public String getSlotNameForBackfillTask() {
        return this.getDbzProperties().getProperty(PostgresConnectorConfig.SLOT_NAME.name()) + "_" + this.getSubtaskId();
    }

    public PostgresConnectorConfig getDbzConnectorConfig() {
        return new PostgresConnectorConfig(this.getDbzConfiguration());
    }
}

