/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.source.connection;

import io.debezium.config.Field;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.oceanbase.utils.OceanBaseUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseConnection
extends JdbcConnection {
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseConnection.class);
    private static final Properties DEFAULT_JDBC_PROPERTIES = OceanBaseConnection.initializeDefaultJdbcProperties();
    private static final String MYSQL_URL_PATTERN = "jdbc:mysql://${hostname}:${port}/?connectTimeout=${connectTimeout}";
    private static final String OB_URL_PATTERN = "jdbc:oceanbase://${hostname}:${port}/?connectTimeout=${connectTimeout}";
    private static final int TYPE_BINARY_FLOAT = 100;
    private static final int TYPE_BINARY_DOUBLE = 101;
    private static final int TYPE_TIMESTAMP_WITH_TIME_ZONE = -101;
    private static final int TYPE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = -102;
    private static final int TYPE_INTERVAL_YEAR_TO_MONTH = -103;
    private static final int TYPE_INTERVAL_DAY_TO_SECOND = -104;
    private final String compatibleMode;

    public OceanBaseConnection(String hostname, Integer port, String user, String password, Duration timeout, String compatibleMode, String jdbcDriver, Properties jdbcProperties, ClassLoader classLoader) {
        super(OceanBaseConnection.config(hostname, port, user, password, timeout), JdbcConnection.patternBasedFactory((String)OceanBaseConnection.formatJdbcUrl(jdbcDriver, jdbcProperties), (String)jdbcDriver, (ClassLoader)classLoader, (Field[])new Field[0]), OceanBaseConnection.getQuote(compatibleMode) + "", OceanBaseConnection.getQuote(compatibleMode) + "");
        this.compatibleMode = compatibleMode;
    }

    private static JdbcConfiguration config(String hostname, Integer port, String user, String password, Duration timeout) {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.create().with("hostname", hostname)).with("port", (Object)port)).with("user", user)).with("password", password)).with("connectTimeout", timeout == null ? 30000L : timeout.toMillis())).build();
    }

    private static String formatJdbcUrl(String jdbcDriver, Properties jdbcProperties) {
        Properties combinedProperties = new Properties();
        combinedProperties.putAll((Map<?, ?>)DEFAULT_JDBC_PROPERTIES);
        if (jdbcProperties != null) {
            combinedProperties.putAll((Map<?, ?>)jdbcProperties);
        }
        String urlPattern = OceanBaseUtils.isOceanBaseDriver(jdbcDriver) ? OB_URL_PATTERN : MYSQL_URL_PATTERN;
        StringBuilder jdbcUrlStringBuilder = new StringBuilder(urlPattern);
        combinedProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> jdbcUrlStringBuilder.append("&").append(key).append("=").append(value)));
        return jdbcUrlStringBuilder.toString();
    }

    private static Properties initializeDefaultJdbcProperties() {
        Properties defaultJdbcProperties = new Properties();
        defaultJdbcProperties.setProperty("useInformationSchema", "true");
        defaultJdbcProperties.setProperty("nullCatalogMeansCurrent", "false");
        defaultJdbcProperties.setProperty("useUnicode", "true");
        defaultJdbcProperties.setProperty("zeroDateTimeBehavior", "convertToNull");
        defaultJdbcProperties.setProperty("characterEncoding", "UTF-8");
        defaultJdbcProperties.setProperty("characterSetResults", "UTF-8");
        return defaultJdbcProperties;
    }

    private static char getQuote(String compatibleMode) {
        return "mysql".equalsIgnoreCase(compatibleMode) ? (char)'`' : '\"';
    }

    public long getCurrentTimestampS() throws SQLException {
        try {
            long globalTimestamp = this.getGlobalTimestamp();
            LOG.info("Global timestamp: {}", (Object)globalTimestamp);
            return Long.parseLong(String.valueOf(globalTimestamp).substring(0, 10));
        }
        catch (Exception e) {
            LOG.warn("Failed to get global timestamp, use local timestamp instead");
            return this.getCurrentTimestamp().orElseThrow(IllegalStateException::new).toInstant().getEpochSecond();
        }
    }

    private long getGlobalTimestamp() throws SQLException {
        String schema = "mysql".equalsIgnoreCase(this.compatibleMode) ? "oceanbase" : "SYS";
        return (Long)OceanBaseConnection.querySingleValue((Connection)this.connection(), (String)("SELECT TS_VALUE FROM " + schema + ".V$OB_TIMESTAMP_SERVICE"), ps -> {}, rs -> rs.getLong(1));
    }

    public Optional<Timestamp> getCurrentTimestamp() throws SQLException {
        return (Optional)this.queryAndMap("mysql".equalsIgnoreCase(this.compatibleMode) ? "SELECT CURRENT_TIMESTAMP" : "SELECT CURRENT_TIMESTAMP FROM DUAL", rs -> rs.next() ? Optional.of(rs.getTimestamp(1)) : Optional.empty());
    }

    public List<TableId> getTables(String dbPattern, String tbPattern) throws SQLException {
        ArrayList<TableId> result = new ArrayList<TableId>();
        DatabaseMetaData metaData = this.connection().getMetaData();
        switch (this.compatibleMode.toLowerCase()) {
            case "mysql": {
                List<String> dbNames = this.getResultList(metaData.getCatalogs(), "TABLE_CAT");
                dbNames = dbNames.stream().filter(dbName -> Pattern.matches(dbPattern, dbName)).collect(Collectors.toList());
                for (String dbName2 : dbNames) {
                    List<String> tableNames = this.getResultList(metaData.getTables(dbName2, null, null, this.supportedTableTypes()), "TABLE_NAME");
                    tableNames.stream().filter(tbName -> Pattern.matches(tbPattern, tbName)).forEach(tbName -> result.add(new TableId(dbName2, null, tbName)));
                }
                break;
            }
            case "oracle": {
                List<String> schemaNames = this.getResultList(metaData.getSchemas(), "TABLE_SCHEM");
                schemaNames = schemaNames.stream().filter(schemaName -> Pattern.matches(dbPattern, schemaName)).collect(Collectors.toList());
                for (String schemaName2 : schemaNames) {
                    List<String> tableNames = this.getResultList(metaData.getTables(null, schemaName2, null, this.supportedTableTypes()), "TABLE_NAME");
                    tableNames.stream().filter(tbName -> Pattern.matches(tbPattern, tbName)).forEach(tbName -> result.add(new TableId(null, schemaName2, tbName)));
                }
                break;
            }
            default: {
                throw new FlinkRuntimeException("Unsupported compatible mode: " + this.compatibleMode);
            }
        }
        return result;
    }

    private List<String> getResultList(ResultSet resultSet, String columnName) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        while (resultSet.next()) {
            result.add(resultSet.getString(columnName));
        }
        return result;
    }

    protected String[] supportedTableTypes() {
        return new String[]{"TABLE"};
    }

    public String quotedTableIdString(TableId tableId) {
        return tableId.toQuotedString(OceanBaseConnection.getQuote(this.compatibleMode));
    }

    public void readSchemaForCapturedTables(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc, Set<TableId> capturedTables) throws SQLException {
        HashSet tableIdsBefore = new HashSet(tables.tableIds());
        DatabaseMetaData metadata = this.connection().getMetaData();
        HashMap columnsByTable = new HashMap();
        for (TableId tableId : capturedTables) {
            ResultSet columnMetadata = metadata.getColumns(databaseCatalog, schemaNamePattern, tableId.table(), null);
            Throwable throwable = null;
            try {
                while (columnMetadata.next()) {
                    this.readTableColumn(columnMetadata, tableId, columnFilter).ifPresent(column -> columnsByTable.computeIfAbsent(tableId, t -> new ArrayList()).add(column.create()));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (columnMetadata == null) continue;
                if (throwable != null) {
                    try {
                        columnMetadata.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                columnMetadata.close();
            }
        }
        for (Map.Entry entry : columnsByTable.entrySet()) {
            List pkColumnNames = this.readPrimaryKeyNames(metadata, (TableId)entry.getKey());
            List columns = (List)entry.getValue();
            Collections.sort(columns);
            tables.overwriteTable((TableId)entry.getKey(), columns, pkColumnNames, null);
        }
        if (removeTablesNotFoundInJdbc) {
            tableIdsBefore.removeAll(columnsByTable.keySet());
            tableIdsBefore.forEach(arg_0 -> ((Tables)tables).removeTable(arg_0));
        }
    }

    protected int resolveNativeType(String typeName) {
        String upperCaseTypeName = typeName.toUpperCase();
        if (upperCaseTypeName.startsWith("JSON")) {
            return 12;
        }
        if (upperCaseTypeName.startsWith("NCHAR")) {
            return -15;
        }
        if (upperCaseTypeName.startsWith("NVARCHAR2")) {
            return -9;
        }
        if (upperCaseTypeName.startsWith("TIMESTAMP")) {
            if (upperCaseTypeName.contains("WITH TIME ZONE")) {
                return -101;
            }
            if (upperCaseTypeName.contains("WITH LOCAL TIME ZONE")) {
                return -102;
            }
            return 93;
        }
        if (upperCaseTypeName.startsWith("INTERVAL")) {
            if (upperCaseTypeName.contains("TO MONTH")) {
                return -103;
            }
            if (upperCaseTypeName.contains("TO SECOND")) {
                return -104;
            }
        }
        return -1;
    }

    protected int resolveJdbcType(int metadataJdbcType, int nativeType) {
        switch (metadataJdbcType) {
            case 100: {
                return 7;
            }
            case 101: {
                return 8;
            }
            case -104: 
            case -103: 
            case -102: 
            case -101: {
                return 1111;
            }
        }
        return nativeType == -1 ? metadataJdbcType : nativeType;
    }
}

