/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

public class BsonUtils {
    private BsonUtils() {
    }

    public static int compareBsonValue(BsonValue o1, BsonValue o2) {
        return BsonUtils.compareBsonValue(o1, o2, true);
    }

    private static int compareBsonValue(BsonValue o1, BsonValue o2, boolean isTopLevel) {
        if (isTopLevel) {
            BsonValue element1 = o1;
            BsonValue element2 = o2;
            if (BsonUtils.isArray(o1)) {
                element1 = BsonUtils.smallestValueOfArray(o1.asArray());
            }
            if (BsonUtils.isArray(o2)) {
                element2 = BsonUtils.smallestValueOfArray(o2.asArray());
            }
            return BsonUtils.compareBsonValue(element1, element2, false);
        }
        if (BsonUtils.typeOrder(o1) != BsonUtils.typeOrder(o2)) {
            return Integer.compare(BsonUtils.typeOrder(o1), BsonUtils.typeOrder(o2));
        }
        if (BsonUtils.isNull(o1) || BsonUtils.isMinKey(o1) || BsonUtils.isMaxKey(o1)) {
            return 0;
        }
        if (BsonUtils.isBsonNumber(o1)) {
            return BsonUtils.toDecimal128(o1).compareTo(BsonUtils.toDecimal128(o2));
        }
        if (o1.isString() || o1.isSymbol()) {
            return BsonUtils.toJavaString(o1).compareTo(BsonUtils.toJavaString(o2));
        }
        if (o1.isDocument() || o1.isDBPointer()) {
            return BsonUtils.compareBsonDocument(BsonUtils.toBsonDocument(o1), BsonUtils.toBsonDocument(o2));
        }
        if (o1.isArray()) {
            return BsonUtils.compareBsonArray(o1.asArray(), o2.asArray());
        }
        if (o1.isBinary()) {
            return BsonUtils.compareBsonBinary(o1.asBinary(), o2.asBinary());
        }
        if (o1.isObjectId()) {
            return o1.asObjectId().compareTo(o2.asObjectId());
        }
        if (o1.isBoolean()) {
            return o1.asBoolean().compareTo(o2.asBoolean());
        }
        if (o1.isDateTime()) {
            return o1.asDateTime().compareTo(o2.asDateTime());
        }
        if (o1.isTimestamp()) {
            return o1.asTimestamp().compareTo(o2.asTimestamp());
        }
        if (o1.isRegularExpression() || o1.isJavaScript()) {
            return BsonUtils.toJavaString(o1).compareTo(BsonUtils.toJavaString(o2));
        }
        if (o1.isJavaScriptWithScope()) {
            return BsonUtils.compareJavascriptWithScope(o1.asJavaScriptWithScope(), o2.asJavaScriptWithScope());
        }
        throw new IllegalArgumentException(String.format("Unable to compare bson values between %s and %s", o1, o2));
    }

    public static int compareBsonDocument(BsonDocument d1, BsonDocument d2) {
        ArrayList pairs1 = new ArrayList(d1.entrySet());
        ArrayList pairs2 = new ArrayList(d2.entrySet());
        if (pairs1.isEmpty() && pairs2.isEmpty()) {
            return 0;
        }
        if (pairs1.isEmpty()) {
            return -1;
        }
        if (pairs2.isEmpty()) {
            return 1;
        }
        int minLength = Math.min(pairs1.size(), pairs2.size());
        for (int i = 0; i < minLength; ++i) {
            String k1 = (String)((Map.Entry)pairs1.get(i)).getKey();
            String k2 = (String)((Map.Entry)pairs2.get(i)).getKey();
            BsonValue v1 = (BsonValue)((Map.Entry)pairs1.get(i)).getValue();
            BsonValue v2 = (BsonValue)((Map.Entry)pairs2.get(i)).getValue();
            int result = Integer.compare(BsonUtils.typeOrder(v1), BsonUtils.typeOrder(v2));
            if (result != 0) {
                return result;
            }
            result = k1.compareTo(k2);
            if (result != 0) {
                return result;
            }
            result = BsonUtils.compareBsonValue(v1, v2, false);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(pairs1.size(), pairs2.size());
    }

    public static int compareBsonArray(BsonArray a1, BsonArray a2) {
        return BsonUtils.compareBsonValue(BsonUtils.smallestValueOfArray(a1), BsonUtils.smallestValueOfArray(a2), false);
    }

    private static BsonValue smallestValueOfArray(BsonArray bsonArray) {
        if (bsonArray.isEmpty()) {
            return new BsonUndefined();
        }
        if (bsonArray.size() == 1) {
            return bsonArray.get(0);
        }
        List sortedValues = bsonArray.getValues().stream().sorted((e1, e2) -> BsonUtils.compareBsonValue(e1, e2, false)).collect(Collectors.toList());
        return (BsonValue)sortedValues.get(0);
    }

    public static int compareBsonBinary(BsonBinary b1, BsonBinary b2) {
        byte[] data2;
        byte[] data1 = b1.getData();
        int result = Integer.compare(data1.length, (data2 = b2.getData()).length);
        if (result != 0) {
            return result;
        }
        result = Byte.compare(b1.getType(), b2.getType());
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return Integer.compare(data1[i] & 0xFF, data2[i] & 0xFF);
        }
        return 0;
    }

    public static int compareJavascriptWithScope(BsonJavaScriptWithScope c1, BsonJavaScriptWithScope c2) {
        int result = c1.getCode().compareTo(c2.getCode());
        if (result != 0) {
            return result;
        }
        return BsonUtils.compareBsonDocument(c1.getScope(), c2.getScope());
    }

    public static boolean isNull(BsonValue bsonValue) {
        return bsonValue == null || bsonValue.isNull() || bsonValue.getBsonType() == BsonType.UNDEFINED;
    }

    public static boolean isBsonNumber(BsonValue bsonValue) {
        return bsonValue != null && (bsonValue.isNumber() || bsonValue.isDecimal128());
    }

    public static boolean isArray(BsonValue bsonValue) {
        return bsonValue != null && bsonValue.isArray();
    }

    public static boolean isMinKey(BsonValue bsonValue) {
        return bsonValue != null && bsonValue.getBsonType() == BsonType.MIN_KEY;
    }

    public static boolean isMaxKey(BsonValue bsonValue) {
        return bsonValue != null && bsonValue.getBsonType() == BsonType.MAX_KEY;
    }

    public static Decimal128 toDecimal128(BsonValue bsonValue) {
        if (bsonValue.isNumber()) {
            return bsonValue.asNumber().decimal128Value();
        }
        if (bsonValue.isDecimal128()) {
            return bsonValue.asDecimal128().decimal128Value();
        }
        throw new IllegalArgumentException("Cannot convert to Decimal128 with unexpected value: " + bsonValue);
    }

    public static String toJavaString(BsonValue bsonValue) {
        if (bsonValue.isString()) {
            return bsonValue.asString().toString();
        }
        if (bsonValue.isSymbol()) {
            return bsonValue.asSymbol().getSymbol();
        }
        if (bsonValue.isRegularExpression()) {
            BsonRegularExpression regex = bsonValue.asRegularExpression();
            return String.format("/%s/%s", regex.getPattern(), regex.getOptions());
        }
        if (bsonValue.isJavaScript()) {
            return bsonValue.asJavaScript().getCode();
        }
        if (bsonValue.isJavaScriptWithScope()) {
            return bsonValue.asJavaScriptWithScope().getCode();
        }
        throw new IllegalArgumentException("Cannot convert to String with unexpected value: " + bsonValue);
    }

    public static BsonDocument toBsonDocument(BsonValue bsonValue) {
        if (bsonValue.isDocument()) {
            return bsonValue.asDocument();
        }
        if (bsonValue.isDBPointer()) {
            BsonDbPointer dbPointer = bsonValue.asDBPointer();
            return new BsonDocument("$ref", (BsonValue)new BsonString(dbPointer.getNamespace())).append("$id", (BsonValue)new BsonObjectId(dbPointer.getId()));
        }
        throw new IllegalArgumentException("Cannot convert to Document with unexpected value: " + bsonValue);
    }

    public static int typeOrder(BsonValue bsonValue) {
        if (bsonValue == null) {
            return 3;
        }
        switch (bsonValue.getBsonType()) {
            case MIN_KEY: {
                return 1;
            }
            case UNDEFINED: {
                return 2;
            }
            case NULL: {
                return 3;
            }
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case DECIMAL128: {
                return 4;
            }
            case STRING: 
            case SYMBOL: {
                return 5;
            }
            case DOCUMENT: 
            case DB_POINTER: {
                return 6;
            }
            case ARRAY: {
                return 7;
            }
            case BINARY: {
                return 8;
            }
            case OBJECT_ID: {
                return 9;
            }
            case BOOLEAN: {
                return 10;
            }
            case DATE_TIME: {
                return 11;
            }
            case TIMESTAMP: {
                return 12;
            }
            case REGULAR_EXPRESSION: {
                return 13;
            }
            case JAVASCRIPT: {
                return 14;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return 15;
            }
            case MAX_KEY: {
                return 99;
            }
        }
        throw new IllegalArgumentException("Unknown bson type : " + bsonValue.getBsonType());
    }
}

