/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.offset;

import java.util.Map;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.mongodb.source.offset.ChangeStreamOffset;
import org.apache.flink.cdc.connectors.mongodb.source.utils.MongoRecordUtils;

public class ChangeStreamOffsetFactory
extends OffsetFactory {
    public ChangeStreamOffset newOffset(Map<String, String> offset) {
        return new ChangeStreamOffset(offset);
    }

    public ChangeStreamOffset newOffset(String filename, Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by filename and position.");
    }

    public ChangeStreamOffset newOffset(Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by position.");
    }

    public Offset createTimestampOffset(long timestampMillis) {
        return new ChangeStreamOffset(MongoRecordUtils.bsonTimestampFromEpochMillis(timestampMillis));
    }

    public ChangeStreamOffset createInitialOffset() {
        return new ChangeStreamOffset(MongoRecordUtils.currentBsonTimestamp());
    }

    public ChangeStreamOffset createNoStoppingOffset() {
        return ChangeStreamOffset.NO_STOPPING_OFFSET;
    }
}

