/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class CheckpointTransaction {
    private final String transactionalId;
    private final long checkpointId;

    public CheckpointTransaction(String transactionalId, long checkpointId) {
        this.transactionalId = (String)Preconditions.checkNotNull((Object)transactionalId, (String)"transactionalId must not be null");
        this.checkpointId = checkpointId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public String getTransactionalId() {
        return this.transactionalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointTransaction that = (CheckpointTransaction)o;
        return this.checkpointId == that.checkpointId && Objects.equals(this.transactionalId, that.transactionalId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionalId, this.checkpointId);
    }

    public String toString() {
        return "CheckpointTransaction{transactionalId='" + this.transactionalId + "', checkpointId=" + this.checkpointId + "}";
    }
}

