/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Objects;
import org.apache.flink.annotation.Internal;

@Internal
public class TransactionFinished {
    private final String transactionId;
    private final boolean success;

    public TransactionFinished(String transactionId, boolean success) {
        this.transactionId = transactionId;
        this.success = success;
    }

    public static TransactionFinished successful(String transactionalId) {
        return new TransactionFinished(transactionalId, true);
    }

    public static TransactionFinished erroneously(String transactionalId) {
        return new TransactionFinished(transactionalId, false);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionFinished that = (TransactionFinished)object;
        return this.success == that.success && Objects.equals(this.transactionId, that.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.success);
    }

    public String toString() {
        return "TransactionFinished{transactionId='" + this.transactionId + "', success=" + this.success + "}";
    }
}

