/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.sink.internal.TransactionalIdFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public enum TransactionAbortStrategyImpl {
    PROBING{

        @Override
        public void abortTransactions(Context context) {
            for (String prefix : context.getPrefixesToAbort()) {
                this.abortTransactionsWithPrefix(prefix, context);
            }
        }

        private void abortTransactionsWithPrefix(String prefix, Context context) {
            int subtaskId = context.getCurrentSubtaskId();
            while (this.abortTransactionOfSubtask(prefix, subtaskId, context) != 0) {
                subtaskId += context.getCurrentParallelism();
            }
        }

        private int abortTransactionOfSubtask(String prefix, int subtaskId, Context context) {
            int numTransactionAborted = 0;
            long checkpointId = context.getStartCheckpointId();
            while (true) {
                String transactionalId = TransactionalIdFactory.buildTransactionalId(prefix, subtaskId, checkpointId);
                int epoch = context.getTransactionAborter().abortTransaction(transactionalId);
                if (epoch == 0) break;
                ++checkpointId;
                ++numTransactionAborted;
            }
            return numTransactionAborted;
        }
    }
    ,
    LISTING{

        @Override
        public void abortTransactions(Context context) {
            Collection<String> openTransactionsForTopics = context.getOpenTransactionsForTopics();
            if (openTransactionsForTopics.isEmpty()) {
                return;
            }
            List openTransactionsForSubtask = openTransactionsForTopics.stream().filter(name -> this.hasKnownPrefix((String)name, context)).filter(context::ownsTransactionalId).collect(Collectors.toList());
            LOG.warn("Found {} open transactions for subtask {}: {}", new Object[]{openTransactionsForSubtask.size(), context.getCurrentSubtaskId(), openTransactionsForSubtask});
            TransactionAborter transactionAborter = context.getTransactionAborter();
            for (String name2 : openTransactionsForSubtask) {
                if (context.getPrecommittedTransactionalIds().contains(name2)) {
                    LOG.debug("Skipping transaction {} because it's in the list of transactions to be committed", (Object)name2);
                    continue;
                }
                transactionAborter.abortTransaction(name2);
            }
        }

        private boolean hasKnownPrefix(String name, Context context) {
            return context.getPrefixesToAbort().stream().anyMatch(name::startsWith);
        }
    };

    private static final Logger LOG;

    public abstract void abortTransactions(Context var1);

    static {
        LOG = LoggerFactory.getLogger(TransactionAbortStrategyImpl.class);
    }

    public static interface Context {
        public Collection<String> getOpenTransactionsForTopics();

        public int getCurrentSubtaskId();

        public int getCurrentParallelism();

        public boolean ownsTransactionalId(String var1);

        public Set<String> getPrefixesToAbort();

        public Set<String> getPrecommittedTransactionalIds();

        public long getStartCheckpointId();

        public TransactionAborter getTransactionAborter();
    }

    public static interface TransactionAborter {
        public int abortTransaction(String var1);
    }
}

