/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.sink.internal.TransactionAbortStrategyImpl;
import org.apache.flink.connector.kafka.sink.internal.TransactionalIdFactory;
import org.apache.flink.connector.kafka.util.AdminUtils;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TransactionListing;

@Internal
public class TransactionAbortStrategyContextImpl
implements TransactionAbortStrategyImpl.Context {
    private final Supplier<Admin> adminSupplier;
    private final Supplier<Collection<String>> topicNames;
    private final int currentSubtaskId;
    private final int currentParallelism;
    private final Set<Integer> ownedSubtaskIds;
    private final int totalNumberOfOwnedSubtasks;
    private final Set<String> prefixesToAbort;
    private final long startCheckpointId;
    private final TransactionAbortStrategyImpl.TransactionAborter transactionAborter;
    private final Set<String> precommittedTransactionIds;

    public TransactionAbortStrategyContextImpl(Supplier<Collection<String>> topicNames, int currentSubtaskId, int currentParallelism, int[] ownedSubtaskIds, int totalNumberOfOwnedSubtasks, List<String> prefixesToAbort, long startCheckpointId, TransactionAbortStrategyImpl.TransactionAborter transactionAborter, Supplier<Admin> adminSupplier, Set<String> precommittedTransactionIds) {
        this.topicNames = (Supplier)Preconditions.checkNotNull(topicNames, (String)"topicNames must not be null");
        this.currentSubtaskId = currentSubtaskId;
        this.currentParallelism = currentParallelism;
        this.ownedSubtaskIds = Arrays.stream(ownedSubtaskIds).boxed().collect(Collectors.toSet());
        this.totalNumberOfOwnedSubtasks = totalNumberOfOwnedSubtasks;
        this.prefixesToAbort = Set.copyOf(prefixesToAbort);
        this.startCheckpointId = startCheckpointId;
        this.transactionAborter = (TransactionAbortStrategyImpl.TransactionAborter)Preconditions.checkNotNull((Object)transactionAborter, (String)"transactionAborter must not be null");
        this.adminSupplier = (Supplier)Preconditions.checkNotNull(adminSupplier, (String)"adminSupplier must not be null");
        this.precommittedTransactionIds = (Set)Preconditions.checkNotNull(precommittedTransactionIds, (String)"transactionsToBeCommitted must not be null");
    }

    @Override
    public Collection<String> getOpenTransactionsForTopics() {
        return AdminUtils.getOpenTransactionsForTopics(this.adminSupplier.get(), this.topicNames.get()).stream().map(TransactionListing::transactionalId).collect(Collectors.toList());
    }

    @Override
    public boolean ownsTransactionalId(String transactionalId) {
        return this.ownedSubtaskIds.contains(TransactionalIdFactory.extractSubtaskId(transactionalId) % this.totalNumberOfOwnedSubtasks);
    }

    @Override
    public int getCurrentSubtaskId() {
        return this.currentSubtaskId;
    }

    @Override
    public int getCurrentParallelism() {
        return this.currentParallelism;
    }

    @Override
    public Set<String> getPrefixesToAbort() {
        return this.prefixesToAbort;
    }

    @Override
    public Set<String> getPrecommittedTransactionalIds() {
        return this.precommittedTransactionIds;
    }

    @Override
    public long getStartCheckpointId() {
        return this.startCheckpointId;
    }

    @Override
    public TransactionAbortStrategyImpl.TransactionAborter getTransactionAborter() {
        return this.transactionAborter;
    }
}

