/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class FileCompactStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long sizeThreshold;
    private final int numCheckpointsBeforeCompaction;
    private final int numCompactThreads;

    private FileCompactStrategy(long sizeThreshold, int numCheckpointsBeforeCompaction, int numCompactThreads) {
        this.sizeThreshold = sizeThreshold;
        this.numCheckpointsBeforeCompaction = numCheckpointsBeforeCompaction;
        this.numCompactThreads = numCompactThreads;
    }

    public long getSizeThreshold() {
        return this.sizeThreshold;
    }

    public int getNumCheckpointsBeforeCompaction() {
        return this.numCheckpointsBeforeCompaction;
    }

    public int getNumCompactThreads() {
        return this.numCompactThreads;
    }

    public static class Builder {
        private int numCheckpointsBeforeCompaction = -1;
        private long sizeThreshold = -1L;
        private int numCompactThreads = -1;

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder enableCompactionOnCheckpoint(int numCheckpointsBeforeCompaction) {
            Preconditions.checkArgument((numCheckpointsBeforeCompaction > 0 ? 1 : 0) != 0, (Object)"Number of checkpoints before compaction should be more than 0.");
            this.numCheckpointsBeforeCompaction = numCheckpointsBeforeCompaction;
            return this;
        }

        public Builder setSizeThreshold(long sizeThreshold) {
            this.sizeThreshold = sizeThreshold;
            return this;
        }

        public Builder setNumCompactThreads(int numCompactThreads) {
            Preconditions.checkArgument((numCompactThreads > 0 ? 1 : 0) != 0, (Object)"Compact threads should be more than 0.");
            this.numCompactThreads = numCompactThreads;
            return this;
        }

        public FileCompactStrategy build() {
            this.validate();
            return new FileCompactStrategy(this.sizeThreshold, this.numCheckpointsBeforeCompaction, this.numCompactThreads);
        }

        private void validate() {
            if (this.sizeThreshold < 0L && this.numCheckpointsBeforeCompaction <= 0) {
                throw new IllegalArgumentException("At least one trigger condition must be configured.");
            }
        }
    }
}

