/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.assigners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;

@PublicEvolving
public class SimpleSplitAssigner
implements FileSplitAssigner {
    private final ArrayList<FileSourceSplit> splits;

    public SimpleSplitAssigner(Collection<FileSourceSplit> splits) {
        this.splits = new ArrayList<FileSourceSplit>(splits);
    }

    @Override
    public Optional<FileSourceSplit> getNext(String hostname) {
        int size = this.splits.size();
        return size == 0 ? Optional.empty() : Optional.of(this.splits.remove(size - 1));
    }

    @Override
    public void addSplits(Collection<FileSourceSplit> newSplits) {
        this.splits.addAll(newSplits);
    }

    @Override
    public Collection<FileSourceSplit> remainingSplits() {
        return this.splits;
    }

    public String toString() {
        return "SimpleSplitAssigner " + this.splits;
    }
}

