/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.utils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.flink.connector.elasticsearch.NetworkClientConfig;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClientBuilder;

public class RestClientUtils {
    public static RestClientBuilder configureRestClientBuilder(RestClientBuilder builder, NetworkClientConfig networkClientConfig) {
        CredentialsProvider credentialsProvider;
        if (networkClientConfig.getConnectionPathPrefix() != null) {
            builder.setPathPrefix(networkClientConfig.getConnectionPathPrefix());
        }
        if ((credentialsProvider = RestClientUtils.getCredentialsProvider(networkClientConfig)) != null || networkClientConfig.getSSLContextSupplier() != null || networkClientConfig.getSslHostnameVerifier() != null) {
            builder.setHttpClientConfigCallback(httpClientBuilder -> {
                if (credentialsProvider != null) {
                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                }
                if (networkClientConfig.getSSLContextSupplier() != null) {
                    httpClientBuilder.setSSLContext((SSLContext)networkClientConfig.getSSLContextSupplier().get());
                }
                if (networkClientConfig.getSslHostnameVerifier() != null) {
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)networkClientConfig.getSslHostnameVerifier().get());
                }
                return httpClientBuilder;
            });
        }
        if (networkClientConfig.getConnectionRequestTimeout() != null || networkClientConfig.getConnectionTimeout() != null || networkClientConfig.getSocketTimeout() != null) {
            builder.setRequestConfigCallback(requestConfigBuilder -> {
                if (networkClientConfig.getConnectionRequestTimeout() != null) {
                    requestConfigBuilder.setConnectionRequestTimeout(networkClientConfig.getConnectionRequestTimeout().intValue());
                }
                if (networkClientConfig.getConnectionTimeout() != null) {
                    requestConfigBuilder.setConnectTimeout(networkClientConfig.getConnectionTimeout().intValue());
                }
                if (networkClientConfig.getSocketTimeout() != null) {
                    requestConfigBuilder.setSocketTimeout(networkClientConfig.getSocketTimeout().intValue());
                }
                return requestConfigBuilder;
            });
        }
        return builder;
    }

    private static CredentialsProvider getCredentialsProvider(NetworkClientConfig networkClientConfig) {
        BasicCredentialsProvider credentialsProvider = null;
        if (networkClientConfig.getPassword() != null && networkClientConfig.getUsername() != null) {
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(networkClientConfig.getUsername(), networkClientConfig.getPassword()));
        }
        return credentialsProvider;
    }
}

