/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.elasticsearch.ElasticsearchApiCallBridge;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConfiguration;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchDynamicSink;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchDynamicSource;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchSinkBuilderSupplier;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchValidationUtils;
import org.apache.flink.connector.elasticsearch.table.LogicalTypeWithIndex;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.elasticsearch.common.Strings;

@Internal
abstract class ElasticsearchDynamicTableFactoryBase
implements DynamicTableSinkFactory,
DynamicTableSourceFactory {
    private final String factoryIdentifier;
    private final ElasticsearchSinkBuilderSupplier<RowData> sinkBuilderSupplier;

    public ElasticsearchDynamicTableFactoryBase(String factoryIdentifier, ElasticsearchSinkBuilderSupplier<RowData> sinkBuilderSupplier) {
        this.factoryIdentifier = (String)Preconditions.checkNotNull((Object)factoryIdentifier);
        this.sinkBuilderSupplier = (ElasticsearchSinkBuilderSupplier)Preconditions.checkNotNull(sinkBuilderSupplier);
    }

    @Nullable
    String getDocumentType(ElasticsearchConfiguration configuration) {
        return null;
    }

    abstract ElasticsearchApiCallBridge<?> getElasticsearchApiCallBridge();

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        List<LogicalTypeWithIndex> primaryKeyLogicalTypesWithIndex = this.getPrimaryKeyLogicalTypesWithIndex(context);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, ElasticsearchConnectorOptions.FORMAT_OPTION);
        ElasticsearchConfiguration config = this.getConfiguration(helper);
        helper.validate();
        this.validateConfiguration(config);
        return new ElasticsearchDynamicSink((EncodingFormat<SerializationSchema<RowData>>)format, config, primaryKeyLogicalTypesWithIndex, context.getPhysicalRowDataType(), Strings.capitalize((String)this.factoryIdentifier), this.sinkBuilderSupplier, this.getDocumentType(config), this.getLocalTimeZoneId(context.getConfiguration()));
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig options = helper.getOptions();
        DecodingFormat format = helper.discoverDecodingFormat(DeserializationFormatFactory.class, ElasticsearchConnectorOptions.FORMAT_OPTION);
        ElasticsearchConfiguration config = this.getConfiguration(helper);
        helper.validate();
        this.validateConfiguration(config);
        return new ElasticsearchDynamicSource((DecodingFormat<DeserializationSchema<RowData>>)format, config, context.getPhysicalRowDataType(), (Integer)options.get(LookupOptions.MAX_RETRIES), Strings.capitalize((String)this.factoryIdentifier), this.getElasticsearchApiCallBridge(), this.getLookupCache(options), this.getDocumentType(config));
    }

    ElasticsearchConfiguration getConfiguration(FactoryUtil.TableFactoryHelper helper) {
        return new ElasticsearchConfiguration(helper.getOptions());
    }

    @Nullable
    private LookupCache getLookupCache(ReadableConfig tableOptions) {
        DefaultLookupCache cache = null;
        if (((LookupOptions.LookupCacheType)tableOptions.get(LookupOptions.CACHE_TYPE)).equals((Object)LookupOptions.LookupCacheType.PARTIAL)) {
            cache = DefaultLookupCache.fromConfig((ReadableConfig)tableOptions);
        }
        return cache;
    }

    ZoneId getLocalTimeZoneId(ReadableConfig readableConfig) {
        String zone = (String)readableConfig.get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        return zoneId;
    }

    void validateConfiguration(ElasticsearchConfiguration config) {
        config.getHosts();
        ElasticsearchDynamicTableFactoryBase.validate(config.getIndex().length() >= 1, () -> String.format("'%s' must not be empty", ElasticsearchConnectorOptions.INDEX_OPTION.key()));
        int maxActions = config.getBulkFlushMaxActions();
        ElasticsearchDynamicTableFactoryBase.validate(maxActions == -1 || maxActions >= 1, () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION.key(), maxActions));
        long maxSize = config.getBulkFlushMaxByteSize().getBytes();
        long mb1 = 0x100000L;
        ElasticsearchDynamicTableFactoryBase.validate(maxSize == -1L || maxSize >= mb1 && maxSize % mb1 == 0L, () -> String.format("'%s' must be in MB granularity. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_MAX_SIZE_OPTION.key(), config.getBulkFlushMaxByteSize().toHumanReadableString()));
        ElasticsearchDynamicTableFactoryBase.validate(config.getBulkFlushBackoffRetries().map(retries -> retries >= 1).orElse(true), () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION.key(), config.getBulkFlushBackoffRetries().get()));
        if (config.getUsername().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)config.getUsername().get())) {
            ElasticsearchDynamicTableFactoryBase.validate(config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)config.getPassword().get()), () -> String.format("'%s' and '%s' must be set at the same time. Got: username '%s' and password '%s'", ElasticsearchConnectorOptions.USERNAME_OPTION.key(), ElasticsearchConnectorOptions.PASSWORD_OPTION.key(), config.getUsername().get(), config.getPassword().orElse("")));
        }
    }

    static void validate(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new ValidationException(message.get());
        }
    }

    List<LogicalTypeWithIndex> getPrimaryKeyLogicalTypesWithIndex(DynamicTableFactory.Context context) {
        DataType physicalRowDataType = context.getPhysicalRowDataType();
        int[] primaryKeyIndexes = context.getPrimaryKeyIndexes();
        if (primaryKeyIndexes.length != 0) {
            DataType pkDataType = Projection.of((int[])primaryKeyIndexes).project(physicalRowDataType);
            ElasticsearchValidationUtils.validatePrimaryKey(pkDataType);
        }
        ResolvedSchema resolvedSchema = context.getCatalogTable().getResolvedSchema();
        return Arrays.stream(primaryKeyIndexes).mapToObj(index -> {
            Optional column = resolvedSchema.getColumn(index);
            if (!column.isPresent()) {
                throw new IllegalStateException(String.format("No primary key column found with index '%s'.", index));
            }
            LogicalType logicalType = ((Column)column.get()).getDataType().getLogicalType();
            return new LogicalTypeWithIndex(index, logicalType);
        }).collect(Collectors.toList());
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Stream.of(ElasticsearchConnectorOptions.HOSTS_OPTION, ElasticsearchConnectorOptions.INDEX_OPTION).collect(Collectors.toSet());
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Stream.of(ElasticsearchConnectorOptions.KEY_DELIMITER_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_MAX_SIZE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_INTERVAL_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION, ElasticsearchConnectorOptions.CONNECTION_PATH_PREFIX_OPTION, ElasticsearchConnectorOptions.CONNECTION_REQUEST_TIMEOUT, ElasticsearchConnectorOptions.CONNECTION_TIMEOUT, ElasticsearchConnectorOptions.SOCKET_TIMEOUT, ElasticsearchConnectorOptions.FORMAT_OPTION, ElasticsearchConnectorOptions.DELIVERY_GUARANTEE_OPTION, ElasticsearchConnectorOptions.PASSWORD_OPTION, ElasticsearchConnectorOptions.USERNAME_OPTION, FactoryUtil.SINK_PARALLELISM, LookupOptions.CACHE_TYPE, LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS, LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE, LookupOptions.PARTIAL_CACHE_MAX_ROWS, LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY, LookupOptions.MAX_RETRIES).collect(Collectors.toSet());
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(ElasticsearchConnectorOptions.HOSTS_OPTION, ElasticsearchConnectorOptions.INDEX_OPTION, ElasticsearchConnectorOptions.PASSWORD_OPTION, ElasticsearchConnectorOptions.USERNAME_OPTION, ElasticsearchConnectorOptions.KEY_DELIMITER_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_MAX_SIZE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_INTERVAL_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION, ElasticsearchConnectorOptions.CONNECTION_PATH_PREFIX_OPTION, ElasticsearchConnectorOptions.CONNECTION_REQUEST_TIMEOUT, ElasticsearchConnectorOptions.CONNECTION_TIMEOUT, ElasticsearchConnectorOptions.SOCKET_TIMEOUT).collect(Collectors.toSet());
    }

    public String factoryIdentifier() {
        return this.factoryIdentifier;
    }
}

