/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.connector.elasticsearch.ElasticsearchApiCallBridge;
import org.apache.flink.connector.elasticsearch.NetworkClientConfig;
import org.apache.flink.connector.elasticsearch.lookup.ElasticsearchRowDataLookupFunction;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConfiguration;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class ElasticsearchDynamicSource
implements LookupTableSource,
SupportsProjectionPushDown {
    private final DecodingFormat<DeserializationSchema<RowData>> format;
    private final ElasticsearchConfiguration config;
    private final int lookupMaxRetryTimes;
    private final LookupCache lookupCache;
    private final String docType;
    private final String summaryString;
    private final ElasticsearchApiCallBridge<?> apiCallBridge;
    private DataType physicalRowDataType;

    public ElasticsearchDynamicSource(DecodingFormat<DeserializationSchema<RowData>> format, ElasticsearchConfiguration config, DataType physicalRowDataType, int lookupMaxRetryTimes, String summaryString, ElasticsearchApiCallBridge<?> apiCallBridge, @Nullable LookupCache lookupCache, @Nullable String docType) {
        this.format = format;
        this.config = config;
        this.physicalRowDataType = physicalRowDataType;
        this.lookupMaxRetryTimes = lookupMaxRetryTimes;
        this.summaryString = summaryString;
        this.apiCallBridge = apiCallBridge;
        this.lookupCache = lookupCache;
        this.docType = docType;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"Elasticsearch only support non-nested look up keys");
            keyNames[i] = (String)DataType.getFieldNames((DataType)this.physicalRowDataType).get(innerKeyArr[0]);
        }
        NetworkClientConfig networkClientConfig = this.buildNetworkClientConfig();
        ElasticsearchRowDataLookupFunction lookupFunction = new ElasticsearchRowDataLookupFunction((DeserializationSchema<RowData>)((DeserializationSchema)this.format.createRuntimeDecoder((DynamicTableSource.Context)context, this.physicalRowDataType)), this.lookupMaxRetryTimes, this.config.getIndex(), this.docType, DataType.getFieldNames((DataType)this.physicalRowDataType).toArray(new String[0]), DataType.getFieldDataTypes((DataType)this.physicalRowDataType).toArray(new DataType[0]), keyNames, this.config.getHosts(), networkClientConfig, this.apiCallBridge);
        if (this.lookupCache != null) {
            return PartialCachingLookupProvider.of(lookupFunction, (LookupCache)this.lookupCache);
        }
        return LookupFunctionProvider.of(lookupFunction);
    }

    private NetworkClientConfig buildNetworkClientConfig() {
        NetworkClientConfig.Builder builder = new NetworkClientConfig.Builder();
        if (this.config.getUsername().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getUsername().get())) {
            builder.setUsername(this.config.getUsername().get());
        }
        if (this.config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getPassword().get())) {
            builder.setPassword(this.config.getPassword().get());
        }
        if (this.config.getPathPrefix().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getPathPrefix().get())) {
            builder.setConnectionPathPrefix(this.config.getPathPrefix().get());
        }
        if (this.config.getConnectionRequestTimeout().isPresent()) {
            builder.setConnectionRequestTimeout((int)this.config.getConnectionRequestTimeout().get().getSeconds());
        }
        if (this.config.getConnectionTimeout().isPresent()) {
            builder.setConnectionTimeout((int)this.config.getConnectionTimeout().get().getSeconds());
        }
        if (this.config.getSocketTimeout().isPresent()) {
            builder.setSocketTimeout((int)this.config.getSocketTimeout().get().getSeconds());
        }
        return builder.build();
    }

    public DynamicTableSource copy() {
        return new ElasticsearchDynamicSource(this.format, this.config, this.physicalRowDataType, this.lookupMaxRetryTimes, this.summaryString, this.apiCallBridge, this.lookupCache, this.docType);
    }

    public String asSummaryString() {
        return this.summaryString;
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType type) {
        this.physicalRowDataType = Projection.of((int[][])projectedFields).project(type);
    }
}

