/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch;

import java.io.Serializable;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.flink.util.function.SerializableSupplier;

public class NetworkClientConfig
implements Serializable {
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String connectionPathPrefix;
    @Nullable
    private final Integer connectionRequestTimeout;
    @Nullable
    private final Integer connectionTimeout;
    @Nullable
    private final Integer socketTimeout;
    @Nullable
    private final SerializableSupplier<SSLContext> sslContextSupplier;
    @Nullable
    private final SerializableSupplier<HostnameVerifier> sslHostnameVerifier;

    public NetworkClientConfig(@Nullable String username, @Nullable String password, @Nullable String connectionPathPrefix, @Nullable Integer connectionRequestTimeout, @Nullable Integer connectionTimeout, @Nullable Integer socketTimeout, @Nullable SerializableSupplier<SSLContext> sslContextSupplier, @Nullable SerializableSupplier<HostnameVerifier> sslHostnameVerifier) {
        this.username = username;
        this.password = password;
        this.connectionPathPrefix = connectionPathPrefix;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.sslContextSupplier = sslContextSupplier;
        this.sslHostnameVerifier = sslHostnameVerifier;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public Integer getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    @Nullable
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Nullable
    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    @Nullable
    public String getConnectionPathPrefix() {
        return this.connectionPathPrefix;
    }

    @Nullable
    public SerializableSupplier<SSLContext> getSSLContextSupplier() {
        return this.sslContextSupplier;
    }

    @Nullable
    public SerializableSupplier<HostnameVerifier> getSslHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public static class Builder {
        private String username;
        private String password;
        private String connectionPathPrefix;
        private Integer connectionRequestTimeout;
        private Integer connectionTimeout;
        private Integer socketTimeout;
        private SerializableSupplier<SSLContext> sslContextSupplier;
        private SerializableSupplier<HostnameVerifier> sslHostnameVerifier;

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setConnectionPathPrefix(String connectionPathPrefix) {
            this.connectionPathPrefix = connectionPathPrefix;
            return this;
        }

        public Builder setConnectionRequestTimeout(Integer connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setSslContextSupplier(SerializableSupplier<SSLContext> sslContextSupplier) {
            this.sslContextSupplier = sslContextSupplier;
            return this;
        }

        public Builder setSslHostnameVerifier(SerializableSupplier<HostnameVerifier> sslHostnameVerifier) {
            this.sslHostnameVerifier = sslHostnameVerifier;
            return this;
        }

        public NetworkClientConfig build() {
            return new NetworkClientConfig(this.username, this.password, this.connectionPathPrefix, this.connectionRequestTimeout, this.connectionTimeout, this.socketTimeout, this.sslContextSupplier, this.sslHostnameVerifier);
        }
    }
}

