/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;

@Internal
@NotThreadSafe
class BufferingNoOpRequestIndexer
implements RequestIndexer {
    private ConcurrentLinkedQueue<ActionRequest> bufferedRequests = new ConcurrentLinkedQueue();

    BufferingNoOpRequestIndexer() {
    }

    @Override
    public void add(DeleteRequest ... deleteRequests) {
        Collections.addAll(this.bufferedRequests, deleteRequests);
    }

    @Override
    public void add(IndexRequest ... indexRequests) {
        Collections.addAll(this.bufferedRequests, indexRequests);
    }

    @Override
    public void add(UpdateRequest ... updateRequests) {
        Collections.addAll(this.bufferedRequests, updateRequests);
    }

    void processBufferedRequests(RequestIndexer actualIndexer) {
        for (ActionRequest request : this.bufferedRequests) {
            if (request instanceof IndexRequest) {
                actualIndexer.add((IndexRequest)request);
                continue;
            }
            if (request instanceof DeleteRequest) {
                actualIndexer.add((DeleteRequest)request);
                continue;
            }
            if (!(request instanceof UpdateRequest)) continue;
            actualIndexer.add((UpdateRequest)request);
        }
        this.bufferedRequests.clear();
    }
}

