/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.dialect;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import org.apache.flink.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.flink.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.db2.source.config.Db2SourceConfig;
import org.apache.flink.cdc.connectors.db2.source.dialect.Db2ChunkSplitter;
import org.apache.flink.cdc.connectors.db2.source.dialect.Db2PooledDataSourceFactory;
import org.apache.flink.cdc.connectors.db2.source.dialect.Db2Schema;
import org.apache.flink.cdc.connectors.db2.source.fetch.Db2ScanFetchTask;
import org.apache.flink.cdc.connectors.db2.source.fetch.Db2SourceFetchTaskContext;
import org.apache.flink.cdc.connectors.db2.source.fetch.Db2StreamFetchTask;
import org.apache.flink.cdc.connectors.db2.source.offset.LsnOffset;
import org.apache.flink.cdc.connectors.db2.source.utils.Db2ConnectionUtils;
import org.apache.flink.cdc.connectors.db2.source.utils.Db2Utils;
import org.apache.flink.util.FlinkRuntimeException;

@Experimental
public class Db2Dialect
implements JdbcDataSourceDialect {
    private static final long serialVersionUID = 1L;
    private final Db2SourceConfig sourceConfig;
    private transient Db2Schema db2Schema;
    private transient Tables.TableFilter filters;

    public Db2Dialect(Db2SourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public String getName() {
        return "Db2";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Offset displayCurrentOffset(JdbcSourceConfig sourceConfig) {
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            LsnOffset lsnOffset = Db2Utils.currentLsn((Db2Connection)jdbcConnection);
            return lsnOffset;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Read the redoLog offset error", (Throwable)e);
        }
    }

    public boolean isDataCollectionIdCaseSensitive(JdbcSourceConfig sourceConfig) {
        return true;
    }

    public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        return Db2ConnectionUtils.createDb2Connection(sourceConfig.getDbzConnectorConfig());
    }

    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig) {
        return new Db2ChunkSplitter(sourceConfig, this);
    }

    public JdbcConnectionPoolFactory getPooledDataSourceFactory() {
        return new Db2PooledDataSourceFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TableId> discoverDataCollections(JdbcSourceConfig sourceConfig) {
        Db2SourceConfig db2SourceConfig = (Db2SourceConfig)sourceConfig;
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            List<TableId> list = Db2ConnectionUtils.listTables(jdbcConnection, db2SourceConfig.getDbzConnectorConfig().getTableFilters());
            return list;
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error to discover tables: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<TableId, TableChanges.TableChange> discoverDataCollectionSchemas(JdbcSourceConfig sourceConfig) {
        List<TableId> capturedTableIds = this.discoverDataCollections(sourceConfig);
        try (Db2Connection jdbc = Db2ConnectionUtils.createDb2Connection(sourceConfig.getDbzConnectorConfig());){
            HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
            for (TableId tableId : capturedTableIds) {
                TableChanges.TableChange tableSchema = this.queryTableSchema(jdbc, tableId);
                tableSchemas.put(tableId, tableSchema);
            }
            HashMap<TableId, TableChanges.TableChange> hashMap = tableSchemas;
            return hashMap;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error to discover table schemas: " + e.getMessage(), (Throwable)e);
        }
    }

    public TableChanges.TableChange queryTableSchema(JdbcConnection jdbc, TableId tableId) {
        if (this.db2Schema == null) {
            this.db2Schema = new Db2Schema();
        }
        return this.db2Schema.getTableSchema(jdbc, tableId, this.sourceConfig.getDbzConnectorConfig().getTableFilters().dataCollectionFilter());
    }

    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase sourceSplitBase) {
        if (sourceSplitBase.isSnapshotSplit()) {
            return new Db2ScanFetchTask(sourceSplitBase.asSnapshotSplit());
        }
        return new Db2StreamFetchTask(sourceSplitBase.asStreamSplit());
    }

    public FetchTask.Context createFetchTaskContext(JdbcSourceConfig sourceConfig) {
        Db2Connection jdbcConnection = Db2ConnectionUtils.createDb2Connection(sourceConfig.getDbzConnectorConfig());
        Db2Connection metaDataConnection = Db2ConnectionUtils.createDb2Connection(sourceConfig.getDbzConnectorConfig());
        return new Db2SourceFetchTaskContext(sourceConfig, this, jdbcConnection, metaDataConnection);
    }

    public boolean isIncludeDataCollection(JdbcSourceConfig sourceConfig, TableId tableId) {
        if (this.filters == null) {
            this.filters = sourceConfig.getTableFilters().dataCollectionFilter();
        }
        return this.filters.isIncluded(tableId);
    }
}

