/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.compress.extractor.Extractor;
import org.apache.flink.formats.compress.writers.HadoopCompressionBulkWriter;
import org.apache.flink.formats.compress.writers.NoCompressionBulkWriter;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

@PublicEvolving
public class CompressWriterFactory<IN>
implements BulkWriter.Factory<IN> {
    private final Extractor<IN> extractor;
    private final Map<String, String> hadoopConfigMap;
    private transient CompressionCodec hadoopCodec;
    private String hadoopCodecName;
    private String codecExtension;

    public CompressWriterFactory(Extractor<IN> extractor) {
        this.extractor = (Extractor)Preconditions.checkNotNull(extractor, (String)"Extractor cannot be null");
        this.hadoopConfigMap = new HashMap<String, String>();
    }

    public CompressWriterFactory<IN> withHadoopCompression(String codecName) throws IOException {
        return this.withHadoopCompression(codecName, new Configuration());
    }

    public CompressWriterFactory<IN> withHadoopCompression(String codecName, Configuration hadoopConfig) throws IOException {
        this.codecExtension = this.getHadoopCodecExtension(codecName, hadoopConfig);
        this.hadoopCodecName = codecName;
        for (Map.Entry entry : hadoopConfig) {
            this.hadoopConfigMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public BulkWriter<IN> create(FSDataOutputStream out) throws IOException {
        if (this.hadoopCodecName == null || this.hadoopCodecName.trim().isEmpty()) {
            return new NoCompressionBulkWriter<IN>(out, this.extractor);
        }
        this.initializeCompressionCodec();
        return new HadoopCompressionBulkWriter<IN>(this.hadoopCodec.createOutputStream((OutputStream)out), this.extractor);
    }

    public String getExtension() {
        return this.hadoopCodecName != null ? this.codecExtension : "";
    }

    private void initializeCompressionCodec() {
        if (this.hadoopCodec == null) {
            Configuration conf = new Configuration();
            for (Map.Entry<String, String> entry : this.hadoopConfigMap.entrySet()) {
                conf.set(entry.getKey(), entry.getValue());
            }
            this.hadoopCodec = new CompressionCodecFactory(conf).getCodecByName(this.hadoopCodecName);
        }
    }

    private String getHadoopCodecExtension(String hadoopCodecName, Configuration conf) throws IOException {
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodecByName(hadoopCodecName);
        if (codec == null) {
            throw new IOException("Unable to load the provided Hadoop codec [" + hadoopCodecName + "]");
        }
        return codec.getDefaultExtension();
    }
}

