/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.udf.UserDefinedFunction;
import org.apache.flink.table.functions.ScalarFunction;

@Internal
public class UserDefinedFunctionDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String classpath;
    private final String className;
    private final DataType returnTypeHint;
    private final boolean isCdcPipelineUdf;
    private final Map<String, String> parameters;

    public UserDefinedFunctionDescriptor(String name, String classpath) {
        this(name, classpath, new HashMap<String, String>());
    }

    public UserDefinedFunctionDescriptor(Tuple3<String, String, Map<String, String>> descriptorTuple) {
        this((String)descriptorTuple.f0, (String)descriptorTuple.f1, (Map)descriptorTuple.f2);
    }

    public UserDefinedFunctionDescriptor(String name, String classpath, Map<String, String> parameters) {
        this.name = name;
        this.parameters = parameters;
        this.classpath = classpath;
        this.className = classpath.substring(classpath.lastIndexOf(46) + 1);
        try {
            Class<?> clazz = Class.forName(classpath);
            this.isCdcPipelineUdf = this.isCdcPipelineUdf(clazz);
            this.returnTypeHint = this.isCdcPipelineUdf ? (DataType)clazz.getMethod("getReturnType", new Class[0]).invoke(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]) : null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to instantiate UDF " + name + "@" + classpath, e);
        }
    }

    private boolean isCdcPipelineUdf(Class<?> clazz) {
        Class<UserDefinedFunction> cdcPipelineUdfClazz = UserDefinedFunction.class;
        Class<ScalarFunction> flinkScalarFunctionClazz = ScalarFunction.class;
        if (Arrays.stream(clazz.getInterfaces()).map(Class::getName).collect(Collectors.toList()).contains(cdcPipelineUdfClazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass().getName().equals(flinkScalarFunctionClazz.getName())) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Failed to detect UDF class " + clazz + " since it never implements %s or extends Flink %s.", cdcPipelineUdfClazz, flinkScalarFunctionClazz));
    }

    public DataType getReturnTypeHint() {
        return this.returnTypeHint;
    }

    public boolean isCdcPipelineUdf() {
        return this.isCdcPipelineUdf;
    }

    public String getName() {
        return this.name;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedFunctionDescriptor that = (UserDefinedFunctionDescriptor)o;
        return this.isCdcPipelineUdf == that.isCdcPipelineUdf && Objects.equals(this.name, that.name) && Objects.equals(this.classpath, that.classpath) && Objects.equals(this.className, that.className) && Objects.equals(this.returnTypeHint, that.returnTypeHint) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.classpath, this.className, this.returnTypeHint, this.isCdcPipelineUdf, this.parameters);
    }

    public String toString() {
        return "UserDefinedFunctionDescriptor{name='" + this.name + '\'' + ", classpath='" + this.classpath + '\'' + ", className='" + this.className + '\'' + ", returnTypeHint=" + this.returnTypeHint + ", isCdcPipelineUdf=" + this.isCdcPipelineUdf + ", parameters=" + this.parameters + '}';
    }
}

