/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.utils;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresPartition;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfig;
import org.apache.flink.util.FlinkRuntimeException;

public class CustomPostgresSchema {
    private final Map<TableId, TableChanges.TableChange> schemasByTableId = new HashMap<TableId, TableChanges.TableChange>();
    private final PostgresConnection jdbcConnection;
    private final PostgresConnectorConfig dbzConfig;

    public CustomPostgresSchema(PostgresConnection jdbcConnection, PostgresSourceConfig sourceConfig) {
        this.jdbcConnection = jdbcConnection;
        this.dbzConfig = sourceConfig.getDbzConnectorConfig();
    }

    public TableChanges.TableChange getTableSchema(TableId tableId) {
        if (!this.schemasByTableId.containsKey(tableId)) {
            try {
                this.readTableSchema(Collections.singletonList(tableId));
            }
            catch (SQLException e) {
                throw new FlinkRuntimeException("Failed to read table schema", (Throwable)e);
            }
        }
        return this.schemasByTableId.get(tableId);
    }

    public Map<TableId, TableChanges.TableChange> getTableSchema(List<TableId> tableIds) {
        HashMap<TableId, TableChanges.TableChange> tableChanges = new HashMap<TableId, TableChanges.TableChange>();
        ArrayList<TableId> unMatchTableIds = new ArrayList<TableId>();
        for (TableId tableId : tableIds) {
            if (this.schemasByTableId.containsKey(tableId)) {
                tableChanges.put(tableId, this.schemasByTableId.get(tableId));
                continue;
            }
            unMatchTableIds.add(tableId);
        }
        if (!unMatchTableIds.isEmpty()) {
            try {
                this.readTableSchema(tableIds);
            }
            catch (SQLException e) {
                throw new FlinkRuntimeException("Failed to read table schema", (Throwable)e);
            }
            for (TableId tableId : unMatchTableIds) {
                if (this.schemasByTableId.containsKey(tableId)) {
                    tableChanges.put(tableId, this.schemasByTableId.get(tableId));
                    continue;
                }
                throw new FlinkRuntimeException(String.format("Failed to read table schema of table %s", tableId));
            }
        }
        return tableChanges;
    }

    private List<TableChanges.TableChange> readTableSchema(List<TableId> tableIds) throws SQLException {
        ArrayList<TableChanges.TableChange> tableChanges = new ArrayList<TableChanges.TableChange>();
        PostgresOffsetContext offsetContext = PostgresOffsetContext.initialContext(this.dbzConfig, this.jdbcConnection, Clock.SYSTEM);
        PostgresPartition partition = new PostgresPartition(this.dbzConfig.getLogicalName());
        Tables tables = new Tables();
        try {
            this.jdbcConnection.readSchema(tables, this.dbzConfig.databaseName(), null, this.dbzConfig.getTableFilters().dataCollectionFilter(), null, false);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to read schema", (Throwable)e);
        }
        for (TableId tableId : tableIds) {
            Table table = Objects.requireNonNull(tables.forTable(tableId));
            offsetContext.event(tableId, Instant.now());
            SchemaChangeEvent schemaChangeEvent = SchemaChangeEvent.ofCreate(partition, offsetContext, this.dbzConfig.databaseName(), tableId.schema(), null, table, true);
            for (TableChanges.TableChange tableChange : schemaChangeEvent.getTableChanges()) {
                this.schemasByTableId.put(tableId, tableChange);
            }
            tableChanges.add(this.schemasByTableId.get(tableId));
        }
        return tableChanges;
    }
}

