/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.flink.deployment;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.utils.Preconditions;

public enum ComposeDeployment {
    YARN_SESSION("yarn-session"),
    YARN_APPLICATION("yarn-application"),
    LOCAL("local"),
    REMOTE("remote"),
    KUBERNETES_APPLICATION("kubernetes-application");

    private final String name;

    private ComposeDeployment(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public static ComposeDeployment getDeploymentFromName(String deploymentTargetStr) {
        return Arrays.stream(ComposeDeployment.values()).filter(d -> d.name.equalsIgnoreCase(deploymentTargetStr)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown deployment target \"" + deploymentTargetStr + "\". The available options are: " + ComposeDeployment.options()));
    }

    private static String options() {
        return Arrays.stream(ComposeDeployment.values()).map(ComposeDeployment::getName).collect(Collectors.joining(","));
    }
}

