/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.flink;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FlinkEnvironmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkEnvironmentUtils.class);

    private FlinkEnvironmentUtils() {
    }

    public static void addJar(StreamExecutionEnvironment env, URL jarUrl) {
        FlinkEnvironmentUtils.addJar(env, Collections.singletonList(jarUrl));
    }

    public static void addJar(StreamExecutionEnvironment env, Collection<URL> jarUrls) {
        try {
            Class<StreamExecutionEnvironment> envClass = StreamExecutionEnvironment.class;
            Field field = envClass.getDeclaredField("configuration");
            field.setAccessible(true);
            Configuration configuration = (Configuration)field.get(env);
            List previousJars = configuration.getOptional(PipelineOptions.JARS).orElse(new ArrayList());
            List currentJars = Stream.concat(previousJars.stream(), jarUrls.stream().map(URL::toString)).distinct().collect(Collectors.toList());
            LOG.info("pipeline.jars is {}", (Object)String.join((CharSequence)",", currentJars));
            configuration.set(PipelineOptions.JARS, currentJars);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add JAR to Flink execution environment", e);
        }
    }
}

