/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.flink.translator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.composer.definition.TransformDef;
import org.apache.flink.cdc.composer.definition.UdfDef;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformOperator;
import org.apache.flink.cdc.runtime.operators.transform.PreTransformOperator;
import org.apache.flink.cdc.runtime.typeutils.EventTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;

public class TransformTranslator {
    public DataStream<Event> translatePreTransform(DataStream<Event> input, List<TransformDef> transforms, List<UdfDef> udfFunctions) {
        if (transforms.isEmpty()) {
            return input;
        }
        PreTransformOperator.Builder preTransformFunctionBuilder = PreTransformOperator.newBuilder();
        for (TransformDef transform : transforms) {
            if (!transform.isValidProjection()) continue;
            preTransformFunctionBuilder.addTransform(transform.getSourceTable(), (String)transform.getProjection().orElse(null), (String)transform.getFilter().orElse(null), transform.getPrimaryKeys(), transform.getPartitionKeys(), transform.getTableOptions());
        }
        preTransformFunctionBuilder.addUdfFunctions(udfFunctions.stream().map(udf -> Tuple2.of((Object)udf.getName(), (Object)udf.getClasspath())).collect(Collectors.toList()));
        return input.transform("Transform:Schema", (TypeInformation)new EventTypeInfo(), (OneInputStreamOperator)preTransformFunctionBuilder.build());
    }

    public DataStream<Event> translatePostTransform(DataStream<Event> input, List<TransformDef> transforms, String timezone, List<UdfDef> udfFunctions) {
        if (transforms.isEmpty()) {
            return input;
        }
        PostTransformOperator.Builder postTransformFunctionBuilder = PostTransformOperator.newBuilder();
        for (TransformDef transform : transforms) {
            if (!transform.isValidProjection() && !transform.isValidFilter()) continue;
            postTransformFunctionBuilder.addTransform(transform.getSourceTable(), transform.isValidProjection() ? transform.getProjection().get() : null, transform.isValidFilter() ? transform.getFilter().get() : null, transform.getPrimaryKeys(), transform.getPartitionKeys(), transform.getTableOptions());
        }
        postTransformFunctionBuilder.addTimezone(timezone);
        postTransformFunctionBuilder.addUdfFunctions(udfFunctions.stream().map(udf -> Tuple2.of((Object)udf.getName(), (Object)udf.getClasspath())).collect(Collectors.toList()));
        return input.transform("Transform:Data", (TypeInformation)new EventTypeInfo(), (OneInputStreamOperator)postTransformFunctionBuilder.build());
    }
}

